<?xml version="1.0" encoding="UTF-8"?>
<!--
Schematron
Generated by CoreFiling: generator revision 605498
Thu Sep 18 09:47:49 BST 2025
-->
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="exslt">
  <sch:title>Schematron for Partnerships</sch:title>
  <sch:ns prefix="hd" uri="http://www.govtalk.gov.uk/CM/envelope"/>
  <sch:ns prefix="dsig" uri="http://www.w3.org/2000/09/xmldsig#"/>
  <sch:ns prefix="ptr" uri="http://www.govtalk.gov.uk/taxation/SA/SA800/25-26/1"/>
    <sch:pattern id="p2">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:IRheader/ptr:Keys/ptr:Key">
        <sch:assert test="count(../../../../../hd:GovTalkDetails/hd:Keys/hd:Key[@Type = current()/@Type and . = current()]) &gt; 0" id="a_header.r1014" diagnostics="errorCode.header.r1014 transactional.header.r1014 transactional.en.header.r1014 ">Keys in the IR header must also exist in the GovTalk header with the same value</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p1">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:IRheader">
        <sch:assert test="count(ptr:Keys/ptr:Key) &gt; 0" id="a_header.r1015" diagnostics="errorCode.header.r1015 transactional.header.r1015 transactional.en.header.r1015 ">At least one key must exist in the IRheader</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p5">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:BusinessInvestmentIncome/ptr:NeitherGoodsNorServicesExported">
        <sch:assert test="not(../ptr:GoodsExported)" id="a_PTF-PTNR-EXPORT-NEITHER.0" diagnostics="errorCode.PTF-PTNR-EXPORT-NEITHER.0 transactional.PTF-PTNR-EXPORT-NEITHER.0 transactional.en.PTF-PTNR-EXPORT-NEITHER.0 ">[6.1N] should not be present if [6.1G] is present</sch:assert>
        <sch:assert test="not(../ptr:ServicesExported)" id="a_PTF-PTNR-EXPORT-NEITHER.1" diagnostics="errorCode.PTF-PTNR-EXPORT-NEITHER.1 transactional.PTF-PTNR-EXPORT-NEITHER.1 transactional.en.PTF-PTNR-EXPORT-NEITHER.1 ">[6.1N] should not be present if [6.1S] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p7">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:AccountingPeriodStart">
        <sch:assert test="../ptr:Description" id="a_PTP-ACCOUNT-START-DATE.0" diagnostics="errorCode.PTP-ACCOUNT-START-DATE.0 transactional.PTP-ACCOUNT-START-DATE.0 transactional.en.PTP-ACCOUNT-START-DATE.0 ">If present then [3.2] must be present</sch:assert>
        <sch:assert test="not((.))
                  or
                not(../../../../ptr:PartnershipSavings/ptr:Interest/ptr:TaxNotDeducted/ptr:TotalInterestTaxNotDeducted)
                  or
                (round(date:seconds(normalize-space((.))) div 86400) = round(date:seconds(normalize-space(../../../../ptr:PartnershipSavings/ptr:Interest/ptr:TaxNotDeducted/ptr:PeriodStart)) div 86400))" id="a_PTP-ACCOUNT-START-DATE.1" diagnostics="errorCode.PTP-ACCOUNT-START-DATE.1 transactional.PTP-ACCOUNT-START-DATE.1 transactional.en.PTP-ACCOUNT-START-DATE.1 ">If both 3.4 [3.4] and 7.6 [7.6] are present then 7.1 [7.1] must equal 3.4 [3.4]</sch:assert>
        <sch:assert test="not((.))
                  or
                not(
                    ../../../../ptr:PartnershipSavings/ptr:OtherIncome/ptr:WithoutTaxDeducted/ptr:Profit
                      or
                    ../../../../ptr:PartnershipSavings/ptr:OtherIncome/ptr:WithoutTaxDeducted/ptr:Loss
                    )
                  or
                (round(date:seconds(normalize-space(../../../../ptr:PartnershipSavings/ptr:OtherIncome/ptr:WithoutTaxDeducted/ptr:PeriodStart)) div 86400) = round(date:seconds(normalize-space((.))) div 86400))" id="a_PTP-ACCOUNT-START-DATE.2" diagnostics="errorCode.PTP-ACCOUNT-START-DATE.2 transactional.PTP-ACCOUNT-START-DATE.2 transactional.en.PTP-ACCOUNT-START-DATE.2 ">If both [3.4] and one or more of [7.26] and [7.27] are present then [7.24] must equal [3.4]</sch:assert>
        <sch:assert test="(round(date:seconds(normalize-space(../../../ptr:PartnershipStatement/ptr:PartnershipInformation/ptr:PeriodStart)) div 86400) = round(date:seconds(normalize-space((.))) div 86400))" id="a_PTP-ACCOUNT-START-DATE.3" diagnostics="errorCode.PTP-ACCOUNT-START-DATE.3 transactional.PTP-ACCOUNT-START-DATE.3 transactional.en.PTP-ACCOUNT-START-DATE.3 ">[N1.1] must equal [3.4]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p8">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:AccountingPeriodEnd">
        <sch:assert test="not(../ptr:AccountingPeriodStart)
                  or
                not((.))
                  or
                (round(date:seconds(normalize-space(../ptr:AccountingPeriodStart)) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))" id="a_PTP-ACCOUNT-END-DATE.0" diagnostics="errorCode.PTP-ACCOUNT-END-DATE.0 transactional.PTP-ACCOUNT-END-DATE.0 transactional.en.PTP-ACCOUNT-END-DATE.0 ">[3.5] should be on or after [3.4]</sch:assert>
        <sch:assert test="not((.))
                  or
                not(../../../../ptr:PartnershipSavings/ptr:Interest/ptr:TaxNotDeducted/ptr:TotalInterestTaxNotDeducted)
                  or
                (round(date:seconds(normalize-space((.))) div 86400) = round(date:seconds(normalize-space(../../../../ptr:PartnershipSavings/ptr:Interest/ptr:TaxNotDeducted/ptr:PeriodEnd)) div 86400))" id="a_PTP-ACCOUNT-END-DATE.1" diagnostics="errorCode.PTP-ACCOUNT-END-DATE.1 transactional.PTP-ACCOUNT-END-DATE.1 transactional.en.PTP-ACCOUNT-END-DATE.1 ">If both [3.5] and [7.6] are present then [7.2] must equal [3.5]</sch:assert>
        <sch:assert test="not((.))
                  or
                not(
                    ../../../../ptr:PartnershipSavings/ptr:OtherIncome/ptr:WithoutTaxDeducted/ptr:Profit
                      or
                    ../../../../ptr:PartnershipSavings/ptr:OtherIncome/ptr:WithoutTaxDeducted/ptr:Loss
                    )
                  or
                (round(date:seconds(normalize-space(../../../../ptr:PartnershipSavings/ptr:OtherIncome/ptr:WithoutTaxDeducted/ptr:PeriodEnd)) div 86400) = round(date:seconds(normalize-space((.))) div 86400))" id="a_PTP-ACCOUNT-END-DATE.2" diagnostics="errorCode.PTP-ACCOUNT-END-DATE.2 transactional.PTP-ACCOUNT-END-DATE.2 transactional.en.PTP-ACCOUNT-END-DATE.2 ">If both [3.5] and one or more of [7.26] and [7.27] are present then [7.25] must equal [3.5]</sch:assert>
        <sch:assert test="(round(date:seconds(normalize-space(../../../ptr:PartnershipStatement/ptr:PartnershipInformation/ptr:PeriodEnd)) div 86400) = round(date:seconds(normalize-space((.))) div 86400))" id="a_PTP-ACCOUNT-END-DATE.3" diagnostics="errorCode.PTP-ACCOUNT-END-DATE.3 transactional.PTP-ACCOUNT-END-DATE.3 transactional.en.PTP-ACCOUNT-END-DATE.3 ">[N1.2] must equal [3.5]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p9">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:DidThisPartnershipStart">
        <sch:assert test="not((.) = &apos;yes&apos;) or ../ptr:DateOfCommencement" id="a_PTP-COMMENCEMENT-QUES.0" diagnostics="errorCode.PTP-COMMENCEMENT-QUES.0 transactional.PTP-COMMENCEMENT-QUES.0 transactional.en.PTP-COMMENCEMENT-QUES.0 ">[3.7] should be present if [3.7Q] equals 'yes'</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p10">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:DateOfCommencement">
        <sch:assert test="(round(date:seconds(normalize-space((.))) div 86400) &lt;= round(date:seconds(normalize-space(concat(2026, &quot;-04-05&quot;))) div 86400))" id="a_PTP-COMMENCEMENT-DATE.0" diagnostics="errorCode.PTP-COMMENCEMENT-DATE.0 transactional.PTP-COMMENCEMENT-DATE.0 transactional.en.PTP-COMMENCEMENT-DATE.0 ">[3.7] must be on or before the last day of the return year.</sch:assert>
        <sch:assert test="(round(date:seconds(normalize-space(concat(2025, &quot;-04-06&quot;))) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))" id="a_PTP-COMMENCEMENT-DATE.1" diagnostics="errorCode.PTP-COMMENCEMENT-DATE.1 transactional.PTP-COMMENCEMENT-DATE.1 transactional.en.PTP-COMMENCEMENT-DATE.1 ">[3.7] must be on or after the first day of the return year.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p11">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:DidThisPartnershipCease">
        <sch:assert test="not((.) = &apos;yes&apos;) or ../ptr:DateOfCessation" id="a_PTP-CESSATION-QUES.0" diagnostics="errorCode.PTP-CESSATION-QUES.0 transactional.PTP-CESSATION-QUES.0 transactional.en.PTP-CESSATION-QUES.0 ">[3.8] should be present if [3.8Q] equals 'yes'</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p12">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:DateOfCessation">
        <sch:assert test="not(../ptr:DateOfCommencement)
                  or
                not((.))
                  or
                (round(date:seconds(normalize-space(../ptr:DateOfCommencement)) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))" id="a_PTP-CESSATION-DATE.0" diagnostics="errorCode.PTP-CESSATION-DATE.0 transactional.PTP-CESSATION-DATE.0 transactional.en.PTP-CESSATION-DATE.0 ">Date of cessation is valid if and only if this on or after [3.7]</sch:assert>
        <sch:assert test="(round(date:seconds(normalize-space(concat(2025, &quot;-04-06&quot;))) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))
                  and
                (round(date:seconds(normalize-space((.))) div 86400) &lt;= round(date:seconds(normalize-space(concat(2026, &quot;-04-05&quot;))) div 86400))" id="a_PTP-CESSATION-DATE.1" diagnostics="errorCode.PTP-CESSATION-DATE.1 transactional.PTP-CESSATION-DATE.1 transactional.en.PTP-CESSATION-DATE.1 ">If [3.8] is present, it must be within the return year</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p13">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:CapitalAllowancesSummary/ptr:AnnualInvestmentAllowance">
        <sch:assert test=". &lt;= 1500000" id="a_PTP-ANNUAL-INV-ALLCE-AMT.0" diagnostics="errorCode.PTP-ANNUAL-INV-ALLCE-AMT.0 transactional.PTP-ANNUAL-INV-ALLCE-AMT.0 transactional.en.PTP-ANNUAL-INV-ALLCE-AMT.0 ">[3.13A] should not exceed [£1,500,000]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p14">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:CapitalAllowancesSummary/ptr:TotalAllowances">
        <sch:assert test="(math:abs((.) - ((
                    sum(../ptr:AnnualInvestmentAllowance) 
                  + sum(../ptr:ZeroEmissionGoodsVehicleAllowance) 
                  + sum(../ptr:CapitalAllowancesEquipmentHigherRate) 
		  + sum(../ptr:CapitalAllowancesEquipmentLowerRate)
		  + sum(../ptr:ZeroEmissionCarAllowanceCapitalAllowances) 
                  + sum(../ptr:ElectricChargePointAllowanceCapitalAllowances) 
		  + sum(../ptr:TheStructuresAndBuildingsAllowanceCapitalAllowances) 
		  + sum(../ptr:FreeportAndInvestmentZonesStructuresAndBuildingsAllowanceCapitalAllowances)
                  + sum(../ptr:OtherCapitalAllowances)
                  ))) &lt; 0.001)" id="a_PTF-CAPITAL-ALLOWANCE-TOTAL.0" diagnostics="errorCode.PTF-CAPITAL-ALLOWANCE-TOTAL.0 transactional.PTF-CAPITAL-ALLOWANCE-TOTAL.0 transactional.en.PTF-CAPITAL-ALLOWANCE-TOTAL.0 ">[3.22] should equal ( the sum of [3.13A], [3.14], [3.14A], [3.16], [3.16A], [3.18], [3.18A], [3.18B] and [3.20] ).</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p15">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:CapitalAllowancesSummary/ptr:TotalBalancingCharges">
        <sch:assert test="(math:abs((.) - ((
                    sum(../ptr:BalancingChargeEquipmentHigherRate) 
                  + sum(../ptr:BalancingChargeEquipmentLowerRate)  
                  + sum(../ptr:BalancingChargesForOtherCapitalAllowances)
                  ))) &lt; 0.001)" id="a_PTP4-TOTAL-BALANCING-CHARGES.0" diagnostics="errorCode.PTP4-TOTAL-BALANCING-CHARGES.0 transactional.PTP4-TOTAL-BALANCING-CHARGES.0 transactional.en.PTP4-TOTAL-BALANCING-CHARGES.0 ">[3.23] should equal ( the sum of [3.15A], [3.17], and [3.21] ).</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p16">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:TurnoverBelowLimit/ptr:Turnover">
        <sch:assert test="(
  ((((.) - sum(../../ptr:CapitalAllowancesSummary/ptr:TotalBalancingCharges)) * 
                  round(date:seconds(date:difference(concat(2026 - 1, &apos;-04-06&apos;), concat(2026, &apos;-04-06&apos;))) div 86400)
                 div (round(date:seconds(date:difference(string(../../ptr:AccountingPeriodStart), string(../../ptr:AccountingPeriodEnd))) div 86400) + 1)) - (90000) &lt;= -0.001)
)
  or
(
  ((((.) - sum(../../ptr:CapitalAllowancesSummary/ptr:TotalBalancingCharges)) * 
                  round(date:seconds(date:difference(concat(2026 - 1, &apos;-04-06&apos;), concat(2026, &apos;-04-06&apos;))) div 86400)
                 div (round(date:seconds(date:difference(string(../../ptr:AccountingPeriodStart), string(../../ptr:AccountingPeriodEnd))) div 86400) + 1)) - (15000000) &gt;= 0.001)
)" id="a_PTP4-TURNOVER-AND-RECEIPTS.0" diagnostics="errorCode.PTP4-TURNOVER-AND-RECEIPTS.0 transactional.PTP4-TURNOVER-AND-RECEIPTS.0 transactional.en.PTP4-TURNOVER-AND-RECEIPTS.0 ">([3.24] - [3.23]) multiplied by days in return year (365 or 366) divided by days in period which begins in [3.4] and ends in [3.5] must be &lt; [£90,000] or &gt; [£15,000,000].</sch:assert>
        <sch:assert test="../../ptr:AccountingPeriodStart" id="a_PTP4-TURNOVER-AND-RECEIPTS.1" diagnostics="errorCode.PTP4-TURNOVER-AND-RECEIPTS.1 transactional.PTP4-TURNOVER-AND-RECEIPTS.1 transactional.en.PTP4-TURNOVER-AND-RECEIPTS.1 ">If [3.24] is present [3.4] must be present.</sch:assert>
        <sch:assert test="../../ptr:AccountingPeriodEnd" id="a_PTP4-TURNOVER-AND-RECEIPTS.2" diagnostics="errorCode.PTP4-TURNOVER-AND-RECEIPTS.2 transactional.PTP4-TURNOVER-AND-RECEIPTS.2 transactional.en.PTP4-TURNOVER-AND-RECEIPTS.2 ">If [3.24] is present [3.5] must be present.</sch:assert>
        <sch:assert test="not((.) &gt; 15000000)
                      or
                    ../../../../../ptr:AttachedFiles/ptr:Attachment" id="a_PTP4-TURNOVER-AND-RECEIPTS.3" diagnostics="errorCode.PTP4-TURNOVER-AND-RECEIPTS.3 transactional.PTP4-TURNOVER-AND-RECEIPTS.3 transactional.en.PTP4-TURNOVER-AND-RECEIPTS.3 ">If [3.24] is present and greater than [£15,000,000] then [RIM-PTR-ATTACHMENT] must be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p17">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:TurnoverBelowLimit/ptr:NetProfitOrLoss">
        <sch:assert test="(math:abs((.) - (sum(../ptr:Turnover) - sum(../ptr:Expenses))) &lt; 0.001)" id="a_PTP-BUSINESS-NET-PROFIT-LOSS.0" diagnostics="errorCode.PTP-BUSINESS-NET-PROFIT-LOSS.0 transactional.PTP-BUSINESS-NET-PROFIT-LOSS.0 transactional.en.PTP-BUSINESS-NET-PROFIT-LOSS.0 ">[3.26] should equal ( [3.24] minus [3.25] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p18">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:ExcludeVAT">
        <sch:assert test="not(. = &apos;yes&apos;) or not(../ptr:IncludeVAT = &apos;yes&apos;)" id="a_RIM-PTNR-EXCLUDE-VAT.0" diagnostics="errorCode.RIM-PTNR-EXCLUDE-VAT.0 transactional.RIM-PTNR-EXCLUDE-VAT.0 transactional.en.RIM-PTNR-EXCLUDE-VAT.0 ">Must not be Y if [3.27] is Y</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p19">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:SalesBusinessIncome">
        <sch:assert test="(.) and ../../ptr:AccountingPeriodStart" id="a_PTP-BUSINESS-SALES-TURNOVER.0" diagnostics="errorCode.PTP-BUSINESS-SALES-TURNOVER.0 transactional.PTP-BUSINESS-SALES-TURNOVER.0 transactional.en.PTP-BUSINESS-SALES-TURNOVER.0 ">Sales business income is valid if and only if [3.4] present</sch:assert>
        <sch:assert test="not(../../ptr:TurnoverBelowLimit/ptr:Turnover or ../../ptr:TurnoverBelowLimit/ptr:Expenses or ../../ptr:TurnoverBelowLimit/ptr:NetProfitOrLoss)" id="a_PTP-BUSINESS-SALES-TURNOVER.1" diagnostics="errorCode.PTP-BUSINESS-SALES-TURNOVER.1 transactional.PTP-BUSINESS-SALES-TURNOVER.1 transactional.en.PTP-BUSINESS-SALES-TURNOVER.1 ">If present, [3.24], [3.25] and [3.26] must be absent</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p20">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:GrossProfitLoss">
        <sch:assert test="(math:abs((.) - ((sum(../ptr:SalesBusinessIncome) - (sum(../ptr:CostOfSales) + sum(../ptr:SubcontractorCosts) + sum(../ptr:OtherDirectCosts))))) &lt; 0.001)" id="a_PTP-GROSS-PROFIT-LOSS.0" diagnostics="errorCode.PTP-GROSS-PROFIT-LOSS.0 transactional.PTP-GROSS-PROFIT-LOSS.0 transactional.en.PTP-GROSS-PROFIT-LOSS.0 ">[3.49] should equal ( [3.29] minus ( the sum of [3.46], [3.47], and [3.48] ) )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p21">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:OtherIncomeProfits">
        <sch:assert test="(.) and not(../../ptr:TurnoverBelowLimit/ptr:Turnover) and not(../../ptr:TurnoverBelowLimit/ptr:Expenses) and not(../../ptr:TurnoverBelowLimit/ptr:NetProfitOrLoss) and ../../ptr:AccountingPeriodStart" id="a_PTP-OTHER-INCOME-PROFITS.0" diagnostics="errorCode.PTP-OTHER-INCOME-PROFITS.0 transactional.PTP-OTHER-INCOME-PROFITS.0 transactional.en.PTP-OTHER-INCOME-PROFITS.0 ">Other income profits is valid if and only if not [3.24] and not [3.25] and not [3.26] and [3.4]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p22">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:DepreciationAndLoss">
        <sch:assert test="../ptr:DisallowableDepreciation" id="a_PTP-DEPRECIATION.0" diagnostics="errorCode.PTP-DEPRECIATION.0 transactional.PTP-DEPRECIATION.0 transactional.en.PTP-DEPRECIATION.0 ">If present [3.44] must be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p23">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:TotalExpenses">
        <sch:assert test="(math:abs((.) - ((sum(../ptr:EmployeeCosts) + sum(../ptr:PremisesCosts) + sum(../ptr:Repairs) + sum(../ptr:GeneralAdministrativeExpenses) + sum(../ptr:MotorExpenses) + sum(../ptr:TravelAndSubsistence) + sum(../ptr:AdvertisingEtc) + sum(../ptr:LegalAndProfessionalCosts) + sum(../ptr:BadDebts) + sum(../ptr:Interest) + sum(../ptr:OtherFinanceCharges) + sum(../ptr:DepreciationAndLoss) + sum(../ptr:OtherExpenses)))) &lt; 0.001)" id="a_PTP-TOTAL-EXPENDITURE.0" diagnostics="errorCode.PTP-TOTAL-EXPENDITURE.0 transactional.PTP-TOTAL-EXPENDITURE.0 transactional.en.PTP-TOTAL-EXPENDITURE.0 ">[3.64] should equal ( the sum of [3.51], [3.52], [3.53], [3.54], [3.55], [3.56], [3.57], [3.58], [3.59], [3.60], [3.61], [3.62], and [3.63] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p24">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:NetProfitOrLoss">
        <sch:assert test="(math:abs((.) - (((sum(../ptr:GrossProfitLoss) + sum(../ptr:OtherIncomeProfits)) - sum(../ptr:TotalExpenses)))) &lt; 0.001)" id="a_PTP3-NET-PROFIT-LOSS.0" diagnostics="errorCode.PTP3-NET-PROFIT-LOSS.0 transactional.PTP3-NET-PROFIT-LOSS.0 transactional.en.PTP3-NET-PROFIT-LOSS.0 ">[3.65] should equal ( ( [3.49] plus [3.50] ) minus [3.64] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p25">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:TaxAdjustments/ptr:AdditionsToNetProfit/ptr:DisallowableExpenses">
        <sch:assert test="((.) - ((sum(../../../ptr:IncomeAndExpenses/ptr:TotalExpenses) + sum(../../../ptr:IncomeAndExpenses/ptr:CostOfSales) + sum(../../../ptr:IncomeAndExpenses/ptr:SubcontractorCosts) + sum(../../../ptr:IncomeAndExpenses/ptr:OtherDirectCosts))) &lt; 0.001)" id="a_PTP-DISALLOW-EXPENDITURE.0" diagnostics="errorCode.PTP-DISALLOW-EXPENDITURE.0 transactional.PTP-DISALLOW-EXPENDITURE.0 transactional.en.PTP-DISALLOW-EXPENDITURE.0 ">[3.66] should not exceed ( the sum of [3.64], [3.46], [3.47], and [3.48] )</sch:assert>
        <sch:assert test="(math:abs((.) - (sum(../../../ptr:IncomeAndExpenses/ptr:DisallowableCostOfSales) + sum(../../../ptr:IncomeAndExpenses/ptr:DisallowableSubContractorCosts) + sum(../../../ptr:IncomeAndExpenses/ptr:DisallowableDirectCosts) + sum(../../../ptr:IncomeAndExpenses/ptr:DisallowableEmployeeCosts) + sum(../../../ptr:IncomeAndExpenses/ptr:DisallowablePremisesCosts) + sum(../../../ptr:IncomeAndExpenses/ptr:DisallowableRepairs) + sum(../../../ptr:IncomeAndExpenses/ptr:DisallowableAdminExpenses) + sum(../../../ptr:IncomeAndExpenses/ptr:DisallowableMotorExpenses) + sum(../../../ptr:IncomeAndExpenses/ptr:DisallowableTravelExpenses) + sum(../../../ptr:IncomeAndExpenses/ptr:DisallowableAdvertisingExpenses) + sum(../../../ptr:IncomeAndExpenses/ptr:DisallowableLegalProfessionalCost) + sum(../../../ptr:IncomeAndExpenses/ptr:DisallowableBadDebts) + sum(../../../ptr:IncomeAndExpenses/ptr:DisallowableInterest) + sum(../../../ptr:IncomeAndExpenses/ptr:DisallowableOtherFinanceCharges) + sum(../../../ptr:IncomeAndExpenses/ptr:DisallowableDepreciation) + sum(../../../ptr:IncomeAndExpenses/ptr:DisallowableOtherExpenses))) &lt; 0.001)" id="a_PTP-DISALLOW-EXPENDITURE.1" diagnostics="errorCode.PTP-DISALLOW-EXPENDITURE.1 transactional.PTP-DISALLOW-EXPENDITURE.1 transactional.en.PTP-DISALLOW-EXPENDITURE.1 ">Must equal sum of ([3.30], [3.31], [3.32], [3.33], [3.34], [3.35], [3.36], [3.37], [3.38], [3.39], [3.40], [3.41], [3.42], [3.43], [3.44], [3.45])</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p26">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:TaxAdjustments/ptr:AdditionsToNetProfit/ptr:TotalAdditionsToNetProfit">
        <sch:assert test="(math:abs((.) - ((sum(../ptr:DisallowableExpenses) + sum(../ptr:GoodsTakenForPersonalUse) + sum(../ptr:BalancingCharge)))) &lt; 0.001)" id="a_PTP-ADDITIONS-TO-NET-PROFIT.0" diagnostics="errorCode.PTP-ADDITIONS-TO-NET-PROFIT.0 transactional.PTP-ADDITIONS-TO-NET-PROFIT.0 transactional.en.PTP-ADDITIONS-TO-NET-PROFIT.0 ">[3.69] should equal ( the sum of [3.66], [3.67], and [3.68] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p27">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:TaxAdjustments/ptr:DeductionsFromNetProfit/ptr:CapitalAllowances">
        <sch:assert test="(.) and ((. = sum(../../../ptr:CapitalAllowancesSummary/ptr:TotalAllowances)) or ../../../ptr:TurnoverBelowLimit/ptr:Turnover or ../../../ptr:TurnoverBelowLimit/ptr:Expenses or ../../../ptr:TurnoverBelowLimit/ptr:NetProfitOrLoss)" id="a_PTP4-CAPITAL-ALLOWANCES.0" diagnostics="errorCode.PTP4-CAPITAL-ALLOWANCES.0 transactional.PTP4-CAPITAL-ALLOWANCES.0 transactional.en.PTP4-CAPITAL-ALLOWANCES.0 ">[3.70] should equal [3.22] or [3.24] present or [3.25] present or [3.26] present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p28">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:TaxAdjustments/ptr:DeductionsFromNetProfit/ptr:TotalDeductionsFromNetProfit">
        <sch:assert test="(math:abs((.) - ((sum(../ptr:CapitalAllowances) + sum(../ptr:Deductions)))) &lt; 0.001)" id="a_PTP-TOTAL-DEDUCTIONS.0" diagnostics="errorCode.PTP-TOTAL-DEDUCTIONS.0 transactional.PTP-TOTAL-DEDUCTIONS.0 transactional.en.PTP-TOTAL-DEDUCTIONS.0 ">[3.72] should equal ( [3.70] plus [3.71] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p29">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:TaxAdjustments/ptr:NetProfitLoss">
        <sch:assert test="(math:abs((.) - (sum(../../ptr:IncomeAndExpenses/ptr:NetProfitOrLoss) + sum(../ptr:AdditionsToNetProfit/ptr:TotalAdditionsToNetProfit) - sum(../ptr:DeductionsFromNetProfit/ptr:TotalDeductionsFromNetProfit))) &lt; 0.001)" id="a_PTP4-NET-BUSINESS-PROFIT-LOSS.1" diagnostics="errorCode.PTP4-NET-BUSINESS-PROFIT-LOSS.1 transactional.PTP4-NET-BUSINESS-PROFIT-LOSS.1 transactional.en.PTP4-NET-BUSINESS-PROFIT-LOSS.1 ">Must equal [3.65] + [3.69] - [3.72]</sch:assert>
        <sch:assert test="../../ptr:AccountingPeriodStart" id="a_PTP4-NET-BUSINESS-PROFIT-LOSS.2" diagnostics="errorCode.PTP4-NET-BUSINESS-PROFIT-LOSS.2 transactional.PTP4-NET-BUSINESS-PROFIT-LOSS.2 transactional.en.PTP4-NET-BUSINESS-PROFIT-LOSS.2 ">If [3.73] is present [3.4] must be present.</sch:assert>
        <sch:assert test="not(../../ptr:TurnoverBelowLimit/ptr:Turnover or ../../ptr:TurnoverBelowLimit/ptr:Expenses or ../../ptr:TurnoverBelowLimit/ptr:NetProfitOrLoss)" id="a_PTP4-NET-BUSINESS-PROFIT-LOSS.3" diagnostics="errorCode.PTP4-NET-BUSINESS-PROFIT-LOSS.3 transactional.PTP4-NET-BUSINESS-PROFIT-LOSS.3 transactional.en.PTP4-NET-BUSINESS-PROFIT-LOSS.3 ">If present, all of the following must be absent: [3.24], [3.25], [3.26]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p31">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:AdjustmentsForTaxableProfitOrLoss/ptr:NetProfit">
        <sch:assert test="../../ptr:DetailsNotRequired 
or 
../ptr:ProvisionalProfitLoss 
or 
(
  ( 
    (not(../../ptr:TurnoverBelowLimit/ptr:NetProfitOrLoss) or sum(../../ptr:TurnoverBelowLimit/ptr:NetProfitOrLoss) &lt; 0) 
    or 
    (.) = sum(../../ptr:TurnoverBelowLimit/ptr:NetProfitOrLoss)
  ) 
  and 
  ( 
    (../../ptr:TurnoverBelowLimit/ptr:NetProfitOrLoss or not(../../ptr:TaxAdjustments/ptr:NetProfitLoss &gt;= 0)) 
    or 
    (.) = sum(../../ptr:TaxAdjustments/ptr:NetProfitLoss)
  )
)" id="a_PTP-NET-PROFIT-FOR-YEAR.0" diagnostics="errorCode.PTP-NET-PROFIT-FOR-YEAR.0 transactional.PTP-NET-PROFIT-FOR-YEAR.0 transactional.en.PTP-NET-PROFIT-FOR-YEAR.0 ">Net profit is valid if and only if [3.10] != 'no' or [3.93] != 'no', or alternatively if one of the following conditions is met: if [3.26] is present and non-negative, then this must equal [3.26]; otherwise, if [3.26] is absent and [3.73] is non-negative then this must equal [3.73]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p32">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:AdjustmentsForTaxableProfitOrLoss/ptr:AllowableLoss">
        <sch:assert test="sum(../ptr:NetProfit) = 0 or (.) = 0" id="a_PTP-ALLOWABLE-LOSS-FOR-YEAR.1" diagnostics="errorCode.PTP-ALLOWABLE-LOSS-FOR-YEAR.1 transactional.PTP-ALLOWABLE-LOSS-FOR-YEAR.1 transactional.en.PTP-ALLOWABLE-LOSS-FOR-YEAR.1 ">If [3.84] is a loss [3.83] must be absent or zero. If [3.83] is a profit then [3.84] MUST BE ABSENT OR ZERO</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p33">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:AdjustmentsForTaxableProfitOrLoss/ptr:ProvisionalProfitLoss">
        <sch:assert test="not((.) = &quot;yes&quot;) or (../../../../ptr:OtherInformation/ptr:IncludesProvisionalFigures = &quot;yes&quot;)" id="a_PTP-ESTIMATED-FIGURES-SIG.1" diagnostics="errorCode.PTP-ESTIMATED-FIGURES-SIG.1 transactional.PTP-ESTIMATED-FIGURES-SIG.1 transactional.en.PTP-ESTIMATED-FIGURES-SIG.1 ">If [3.93] is Y then [10.1] must also be Y (but the reverse is not true as estimated figures may be present elsewhere on the return)</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p30">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:AdjustmentsForTaxableProfitOrLoss">
        <sch:assert test="(../ptr:DetailsNotRequired != &apos;no&apos;)
                or 
                (ptr:ProvisionalProfitLoss != &apos;no&apos;)
                or
                (
                  (  not(../ptr:TurnoverBelowLimit/ptr:NetProfitOrLoss) 
                     or 
                     (sum(../ptr:TurnoverBelowLimit/ptr:NetProfitOrLoss) &gt;= 0)
                     or 
                     (sum(ptr:AllowableLoss) = (0 - sum(../ptr:TurnoverBelowLimit/ptr:NetProfitOrLoss)))
                  ) 

                  and 
                  
                  (
                     ../ptr:TurnoverBelowLimit/ptr:NetProfitOrLoss 
                     or
                     not(sum(../ptr:TaxAdjustments/ptr:NetProfitLoss) &lt; 0)
                     or
                     (sum(ptr:AllowableLoss) = (0 - sum(../ptr:TaxAdjustments/ptr:NetProfitLoss)))
                  )
                )" id="a_PTP-ESTIMATED-FIGURES-SIG.0" diagnostics="errorCode.PTP-ESTIMATED-FIGURES-SIG.0 transactional.PTP-ESTIMATED-FIGURES-SIG.0 transactional.en.PTP-ESTIMATED-FIGURES-SIG.0 ">Provisional profit loss is valid if and only if [3.10] != 'no' or [3.93] != 'no', or alternatively if one of the following conditions is met: if [3.26] is present and negative, then [3.84] equals the positive equivalent of [3.26]; otherwise, if [3.26] is absent and [3.73] is negative then [3.84] equals the positive equivalent of [3.73]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p34">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:SummaryOfBalanceSheet/ptr:Assets/ptr:TotalAssets">
        <sch:assert test="(math:abs((.) - ((sum(../ptr:PlantMachineryAndMotorVehicles) + sum(../ptr:OtherFixedAssets) + sum(../ptr:StockAndWorkInProgress) + sum(../ptr:DebtorsPrepaymentsEtc) + sum(../ptr:BankEtcBalances) + sum(../ptr:CashInHand)))) &lt; 0.001)" id="a_RIM-PTNR-TOTAL-ASSETS.0" diagnostics="errorCode.RIM-PTNR-TOTAL-ASSETS.0 transactional.RIM-PTNR-TOTAL-ASSETS.0 transactional.en.RIM-PTNR-TOTAL-ASSETS.0 ">[3.105] should equal ( the sum of [3.99], [3.100], [3.101], [3.102], [3.103], and [3.104] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p35">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:SummaryOfBalanceSheet/ptr:Liabilities/ptr:TotalLiabilities">
        <sch:assert test="(math:abs((.) - ((sum(../ptr:TradeCreditorsAndAccruals) + sum(../ptr:LoansAndOverdrawnBankAccounts) + sum(../ptr:OtherLiabilities)))) &lt; 0.001)" id="a_RIM-PTNR-TOTAL-LIABILITIES.0" diagnostics="errorCode.RIM-PTNR-TOTAL-LIABILITIES.0 transactional.RIM-PTNR-TOTAL-LIABILITIES.0 transactional.en.RIM-PTNR-TOTAL-LIABILITIES.0 ">[3.109] should equal ( the sum of [3.106], [3.107], and [3.108] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p36">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:SummaryOfBalanceSheet/ptr:NetBusinessAssets">
        <sch:assert test="(math:abs((.) - ((sum(../ptr:Assets/ptr:TotalAssets) - sum(../ptr:Liabilities/ptr:TotalLiabilities)))) &lt; 0.001)" id="a_RIM-PTNR-NET-BUSINESS-ASSETS.0" diagnostics="errorCode.RIM-PTNR-NET-BUSINESS-ASSETS.0 transactional.RIM-PTNR-NET-BUSINESS-ASSETS.0 transactional.en.RIM-PTNR-NET-BUSINESS-ASSETS.0 ">[3.110] should equal ( [3.105] minus [3.109] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p37">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:SummaryOfBalanceSheet/ptr:PartnersCurrentAndCapitalAccounts/ptr:BalanceAtEndOfPeriod">
        <sch:assert test="(math:abs((.) - (((sum(../ptr:BalanceAtStartOfPeriod) + sum(../ptr:NetProfitLoss) + sum(../ptr:CapitalIntroduced)) - sum(../ptr:Drawings)))) &lt; 0.001)" id="a_RIM-PTNR-BAL-END-PERIOD.0" diagnostics="errorCode.RIM-PTNR-BAL-END-PERIOD.0 transactional.RIM-PTNR-BAL-END-PERIOD.0 transactional.en.RIM-PTNR-BAL-END-PERIOD.0 ">[3.115] should equals ( ( the sum of [3.111], [3.112], and [3.113] ) minus [3.114] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p6">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income">
        <sch:assert test="(not(ptr:IncomeAndExpenses/ptr:SalesBusinessIncome) and not(ptr:IncomeAndExpenses/ptr:OtherIncomeProfits) and not(ptr:TaxAdjustments/ptr:NetProfitLoss)) or (sum(ptr:TaxAdjustments/ptr:AdditionsToNetProfit/ptr:BalancingCharge) = sum(ptr:CapitalAllowancesSummary/ptr:TotalBalancingCharges))" id="a_PTP4-NET-BUSINESS-PROFIT-LOSS.0" diagnostics="errorCode.PTP4-NET-BUSINESS-PROFIT-LOSS.0 transactional.PTP4-NET-BUSINESS-PROFIT-LOSS.0 transactional.en.PTP4-NET-BUSINESS-PROFIT-LOSS.0 ">Balancing charge must equal total balancing charges if any of [3.29] or [3.50] or [3.73] are present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p39">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:PartnershipStatement/ptr:PartnershipInformation/ptr:PeriodEnd">
        <sch:assert test="not(../ptr:PeriodStart)
                  or
                not((.))
                  or
                (round(date:seconds(normalize-space(../ptr:PeriodStart)) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))" id="a_PSF-ACCOUNT-PERIOD-END-DATE.0" diagnostics="errorCode.PSF-ACCOUNT-PERIOD-END-DATE.0 transactional.PSF-ACCOUNT-PERIOD-END-DATE.0 transactional.en.PSF-ACCOUNT-PERIOD-END-DATE.0 ">[N1.2] should be on or after [N1.1]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p40">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:PartnershipStatement/ptr:PartnershipInformation/ptr:UsesCTrules">
        <sch:assert test="not(../../../../ptr:PartnershipForeign/ptr:IncomeLandPropertyAbroad/ptr:IncomeLandAndPropertyAbroad/ptr:TotalRentsEtc)
                  or
                ../../../../ptr:PartnershipForeign/ptr:ForeignIncomeSavingsLandProperty/ptr:TraditionalAccounting" id="a_PSF-CORPORATION-TAX-RULES-SIG.0" diagnostics="errorCode.PSF-CORPORATION-TAX-RULES-SIG.0 transactional.PSF-CORPORATION-TAX-RULES-SIG.0 transactional.en.PSF-CORPORATION-TAX-RULES-SIG.0 ">If [N1.4] and at least one [2.11] is present then [2.8A] must be submitted</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p41">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:PartnershipStatement/ptr:PartnershipInformation/ptr:ProfitHasForeignTaxDeducted">
        <sch:assert test="not(. = &apos;yes&apos;) or ../ptr:TradeProfit" id="a_PSF-NET-PROFIT-FOR-YEAR-FT-SIG.0" diagnostics="errorCode.PSF-NET-PROFIT-FOR-YEAR-FT-SIG.0 transactional.PSF-NET-PROFIT-FOR-YEAR-FT-SIG.0 transactional.en.PSF-NET-PROFIT-FOR-YEAR-FT-SIG.0 ">[N1.11] must be present if [N1.A] = Y</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p42">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:PartnershipStatement/ptr:PartnershipInformation/ptr:LossHasForeignTaxDeducted">
        <sch:assert test="not(. = &apos;yes&apos;) or ../ptr:TradeLoss" id="a_PSF-ALLOWABLE-LOSS-YEAR-FT-SIG.0" diagnostics="errorCode.PSF-ALLOWABLE-LOSS-YEAR-FT-SIG.0 transactional.PSF-ALLOWABLE-LOSS-YEAR-FT-SIG.0 transactional.en.PSF-ALLOWABLE-LOSS-YEAR-FT-SIG.0 ">[N1.12] must be present if [N1.B] = Y</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p43">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:PartnershipStatement/ptr:PartnershipInformation/ptr:ForeignSavingsHasForeignTaxDeducted">
        <sch:assert test="not(. = &apos;yes&apos;) or ../ptr:UntaxedForeignSavingsIncome" id="a_PSF-UNTAXED-FOREIGN-FT-SIG.0" diagnostics="errorCode.PSF-UNTAXED-FOREIGN-FT-SIG.0 transactional.PSF-UNTAXED-FOREIGN-FT-SIG.0 transactional.en.PSF-UNTAXED-FOREIGN-FT-SIG.0 ">[N1.14] must be present if [N1.C] = Y</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p44">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:PartnershipStatement/ptr:PartnershipInformation/ptr:OtherUntaxedForeignIncomeHasForeignTaxDeducted">
        <sch:assert test="not(. = &apos;yes&apos;) or ../ptr:IncomeFromLandAndPropertyAbroad" id="a_PSF-OTHER-UNTAXED-F-INC-FT-SIG.0" diagnostics="errorCode.PSF-OTHER-UNTAXED-F-INC-FT-SIG.0 transactional.PSF-OTHER-UNTAXED-F-INC-FT-SIG.0 transactional.en.PSF-OTHER-UNTAXED-F-INC-FT-SIG.0 ">[N1.17] must be present if [N1.D] = Y</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p45">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:PartnershipStatement/ptr:PartnershipInformation/ptr:IncomeFromOffshoreFundsHasForeignTaxDeducted">
        <sch:assert test="not(. = &apos;yes&apos;) or ../ptr:IncomeFromOffshoreFunds" id="a_PSF-INC-OFFSHORE-FUNDS-FT-SIG.0" diagnostics="errorCode.PSF-INC-OFFSHORE-FUNDS-FT-SIG.0 transactional.PSF-INC-OFFSHORE-FUNDS-FT-SIG.0 transactional.en.PSF-INC-OFFSHORE-FUNDS-FT-SIG.0 ">Must be present if [N1.E] = Y</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p46">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:PartnershipStatement/ptr:PartnershipInformation/ptr:OtherTaxedIncomeHasForeignTaxDeducted">
        <sch:assert test="not(. = &apos;yes&apos;) or ../ptr:OtherTaxedIncome" id="a_PSF-OTHER-OI-BEFORE-TAX-FT-SIG.0" diagnostics="errorCode.PSF-OTHER-OI-BEFORE-TAX-FT-SIG.0 transactional.PSF-OTHER-OI-BEFORE-TAX-FT-SIG.0 transactional.en.PSF-OTHER-OI-BEFORE-TAX-FT-SIG.0 ">[N1.23] must be present if [N1.H] = Y</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p47">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:PartnershipStatement/ptr:PartnerDetails/ptr:PartnerUTR">
        <sch:assert test="(&apos;1111111111&apos; != (.)) 
                and
              (&apos;2222222222&apos; != (.)) 
                and
              (&apos;3333333333&apos; != (.)) 
                and
              (&apos;4444444444&apos; != (.)) 
                and
              (&apos;5555555555&apos; != (.)) 
                and
              (&apos;6666666666&apos; != (.)) 
                and
              (&apos;7777777777&apos; != (.)) 
                and
              (&apos;8888888888&apos; != (.)) 
                and
              (&apos;9999999999&apos; != (.))" id="a_PPS-PARTNER-REF-NUMBER.1" diagnostics="errorCode.PPS-PARTNER-REF-NUMBER.1 transactional.PPS-PARTNER-REF-NUMBER.1 transactional.en.PPS-PARTNER-REF-NUMBER.1 ">Must be 10 numeric characters, but not 1111111111, 2222222222, 3333333333, 4444444444, 5555555555, 6666666666, 7777777777, 8888888888, 9999999999</sch:assert>
        <sch:assert test="(((11 - (((6 * substring((.), 2, 1)) + (7 * substring((.), 3, 1)) + (8 * substring((.), 4, 1)) + (9 * substring((.), 5, 1)) + (10 * substring((.), 6, 1)) + (5 * substring((.), 7, 1)) + (4 * substring((.), 8, 1)) + (3 * substring((.), 9, 1)) + (2 * substring((.), 10, 1))) mod 11)) &gt; 9) and (substring((.), 1, 1) = (11 - (((6 * substring((.), 2, 1)) + (7 * substring((.), 3, 1)) + (8 * substring((.), 4, 1)) + (9 * substring((.), 5, 1)) + (10 * substring((.), 6, 1)) + (5 * substring((.), 7, 1)) + (4 * substring((.), 8, 1)) + (3 * substring((.), 9, 1)) + (2 * substring((.), 10, 1))) mod 11)) - 9))
                or
                (substring((.), 1, 1) = (11 - (((6 * substring((.), 2, 1)) + (7 * substring((.), 3, 1)) + (8 * substring((.), 4, 1)) + (9 * substring((.), 5, 1)) + (10 * substring((.), 6, 1)) + (5 * substring((.), 7, 1)) + (4 * substring((.), 8, 1)) + (3 * substring((.), 9, 1)) + (2 * substring((.), 10, 1))) mod 11)))" id="a_PPS-PARTNER-REF-NUMBER.0" diagnostics="errorCode.PPS-PARTNER-REF-NUMBER.0 transactional.PPS-PARTNER-REF-NUMBER.0 transactional.en.PPS-PARTNER-REF-NUMBER.0 ">Must be valid against the UTR algorithm</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p48">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:PartnershipStatement/ptr:PartnerDetails/ptr:DateCeased">
        <sch:assert test="not(../ptr:DateAppointed)
                  or
                not((.))
                  or
                (round(date:seconds(normalize-space(../ptr:DateAppointed)) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))" id="a_PPS-CEASED-PARTNER-DATE.0" diagnostics="errorCode.PPS-CEASED-PARTNER-DATE.0 transactional.PPS-CEASED-PARTNER-DATE.0 transactional.en.PPS-CEASED-PARTNER-DATE.0 ">[N2.9] should be on or after [N2.7]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p38">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:PartnershipStatement">
        <sch:assert test="(math:abs((sum(ptr:PartnershipInformation/ptr:TradeProfit)) - (sum(../ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:AdjustmentsForTaxableProfitOrLoss/ptr:NetProfit))) &lt; 0.001)" id="a_RIM-PTNR-PARTNERSHIP-STMT.1" diagnostics="errorCode.RIM-PTNR-PARTNERSHIP-STMT.1 transactional.RIM-PTNR-PARTNERSHIP-STMT.1 transactional.en.RIM-PTNR-PARTNERSHIP-STMT.1 ">If [Partnership statement] is present [N1.11] must be equal to [3.83].</sch:assert>
        <sch:assert test="(math:abs((sum(ptr:PartnershipInformation/ptr:TradeLoss)) - (sum(../ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:AdjustmentsForTaxableProfitOrLoss/ptr:AllowableLoss))) &lt; 0.001)" id="a_RIM-PTNR-PARTNERSHIP-STMT.2" diagnostics="errorCode.RIM-PTNR-PARTNERSHIP-STMT.2 transactional.RIM-PTNR-PARTNERSHIP-STMT.2 transactional.en.RIM-PTNR-PARTNERSHIP-STMT.2 ">If [Partnership statement] is present [N1.12] must be equal to [3.84].</sch:assert>
        <sch:assert test="(math:abs((sum(ptr:PartnershipInformation/ptr:UntaxedUKsavingsIncome)) - (sum(../../ptr:PartnershipSavings/ptr:Interest/ptr:TaxNotDeducted/ptr:TotalInterestTaxNotDeducted))) &lt; 0.001)" id="a_RIM-PTNR-PARTNERSHIP-STMT.3" diagnostics="errorCode.RIM-PTNR-PARTNERSHIP-STMT.3 transactional.RIM-PTNR-PARTNERSHIP-STMT.3 transactional.en.RIM-PTNR-PARTNERSHIP-STMT.3 ">If [Partnership statement] is present [N1.13] must be equal to [7.6].</sch:assert>
        <sch:assert test="(math:abs((sum(ptr:PartnershipInformation/ptr:UntaxedForeignSavingsIncome)) - (sum(../../ptr:PartnershipForeign/ptr:ForeignIncomeSavingsLandProperty/ptr:TotalIncomeRemittable))) &lt; 0.001)" id="a_RIM-PTNR-PARTNERSHIP-STMT.4" diagnostics="errorCode.RIM-PTNR-PARTNERSHIP-STMT.4 transactional.RIM-PTNR-PARTNERSHIP-STMT.4 transactional.en.RIM-PTNR-PARTNERSHIP-STMT.4 ">If [Partnership statement] is present [N1.14] must be equal to [2.6].</sch:assert>
        <sch:assert test="(math:abs((sum(ptr:PartnershipInformation/ptr:OtherUntaxedUKincome)) - (sum(../../ptr:PartnershipSavings/ptr:OtherIncome/ptr:WithoutTaxDeducted/ptr:Profit))) &lt; 0.001)" id="a_RIM-PTNR-PARTNERSHIP-STMT.5" diagnostics="errorCode.RIM-PTNR-PARTNERSHIP-STMT.5 transactional.RIM-PTNR-PARTNERSHIP-STMT.5 transactional.en.RIM-PTNR-PARTNERSHIP-STMT.5 ">If [Partnership statement] is present [N1.15] must be equal to [7.26].</sch:assert>
        <sch:assert test="(math:abs((sum(ptr:PartnershipInformation/ptr:LossFromOtherUntaxedUKincome)) - (sum(../../ptr:PartnershipSavings/ptr:OtherIncome/ptr:WithoutTaxDeducted/ptr:Loss))) &lt; 0.001)" id="a_RIM-PTNR-PARTNERSHIP-STMT.6" diagnostics="errorCode.RIM-PTNR-PARTNERSHIP-STMT.6 transactional.RIM-PTNR-PARTNERSHIP-STMT.6 transactional.en.RIM-PTNR-PARTNERSHIP-STMT.6 ">If [Partnership statement] is present [N1.16] must be equal to [7.27].</sch:assert>
        <sch:assert test="(math:abs((sum(ptr:PartnershipInformation/ptr:IncomeFromLandAndPropertyAbroad)) - (sum(../../ptr:PartnershipForeign/ptr:ForeignIncomeSavingsLandProperty/ptr:TotalGross))) &lt; 0.001)" id="a_RIM-PTNR-PARTNERSHIP-STMT.7" diagnostics="errorCode.RIM-PTNR-PARTNERSHIP-STMT.7 transactional.RIM-PTNR-PARTNERSHIP-STMT.7 transactional.en.RIM-PTNR-PARTNERSHIP-STMT.7 ">If [Partnership statement] is present [N1.17] must be equal to [2.7].</sch:assert>
        <sch:assert test="(math:abs((sum(ptr:PartnershipInformation/ptr:IncomeFromOffshoreFunds)) - (sum(../../ptr:PartnershipForeign/ptr:ForeignIncomeSavingsLandProperty/ptr:DisposalsOfOffshoreFunds))) &lt; 0.001)" id="a_RIM-PTNR-PARTNERSHIP-STMT.8" diagnostics="errorCode.RIM-PTNR-PARTNERSHIP-STMT.8 transactional.RIM-PTNR-PARTNERSHIP-STMT.8 transactional.en.RIM-PTNR-PARTNERSHIP-STMT.8 ">If [Partnership statement] is present [N1.18] must be equal to [2.9].</sch:assert>
        <sch:assert test="(math:abs((sum(ptr:PartnershipInformation/ptr:ProfitLossOnUKlandAndProperty)) - (sum(../../ptr:PartnershipLandProperty/ptr:Property/ptr:ProfitLossForReturnPeriod))) &lt; 0.001)" id="a_RIM-PTNR-PARTNERSHIP-STMT.9" diagnostics="errorCode.RIM-PTNR-PARTNERSHIP-STMT.9 transactional.RIM-PTNR-PARTNERSHIP-STMT.9 transactional.en.RIM-PTNR-PARTNERSHIP-STMT.9 ">If [Partnership statement] is present [N1.19] must be equal to [1.39].</sch:assert>
        <sch:assert test="(math:abs((sum(ptr:PartnershipInformation/ptr:LossOnForeignLetProperty)) - (sum(../../ptr:PartnershipForeign/ptr:ForeignIncomeSavingsLandProperty/ptr:ForeignLettingsLoss))) &lt; 0.001)" id="a_RIM-PTNR-PARTNERSHIP-STMT.12" diagnostics="errorCode.RIM-PTNR-PARTNERSHIP-STMT.12 transactional.RIM-PTNR-PARTNERSHIP-STMT.12 transactional.en.RIM-PTNR-PARTNERSHIP-STMT.12 ">If [Partnership statement] is present [N1.21] must be equal to [2.10].</sch:assert>
        <sch:assert test="(math:abs((sum(ptr:PartnershipInformation/ptr:TaxedSavings)) - (sum(../../ptr:PartnershipSavings/ptr:Interest/ptr:TaxDeducted/ptr:TotalGross))) &lt; 0.001)" id="a_RIM-PTNR-PARTNERSHIP-STMT.13" diagnostics="errorCode.RIM-PTNR-PARTNERSHIP-STMT.13 transactional.RIM-PTNR-PARTNERSHIP-STMT.13 transactional.en.RIM-PTNR-PARTNERSHIP-STMT.13 ">If [Partnership statement] is present [N1.22] must be equal to [7.18].</sch:assert>
        <sch:assert test="(math:abs((sum(ptr:PartnershipInformation/ptr:OtherTaxedIncome)) - (sum(../../ptr:PartnershipSavings/ptr:OtherIncome/ptr:WithTaxDeducted/ptr:Gross))) &lt; 0.001)" id="a_RIM-PTNR-PARTNERSHIP-STMT.14" diagnostics="errorCode.RIM-PTNR-PARTNERSHIP-STMT.14 transactional.RIM-PTNR-PARTNERSHIP-STMT.14 transactional.en.RIM-PTNR-PARTNERSHIP-STMT.14 ">If [Partnership statement] is present [N1.23] must be equal to [7.30].</sch:assert>
        <sch:assert test="(math:abs((sum(ptr:PartnershipInformation/ptr:CIS25deductions)) - (sum(../ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:SubcontractorsDeductionsOnAccountOfTax))) &lt; 0.001)" id="a_RIM-PTNR-PARTNERSHIP-STMT.14a" diagnostics="errorCode.RIM-PTNR-PARTNERSHIP-STMT.14a transactional.RIM-PTNR-PARTNERSHIP-STMT.14a transactional.en.RIM-PTNR-PARTNERSHIP-STMT.14a ">[N1.24] must equal [3.97]</sch:assert>
        <sch:assert test="(math:abs((sum(ptr:PartnershipInformation/ptr:UKincomeTax)) - ((
                sum(../../ptr:PartnershipSavings/ptr:Interest/ptr:TaxDeducted/ptr:TotalTaxDeducted) + 
                sum(../../ptr:PartnershipSavings/ptr:OtherIncome/ptr:WithTaxDeducted/ptr:Tax) + 
                sum(../../ptr:PartnershipLandProperty/ptr:Property/ptr:Income/ptr:RentsEtc/ptr:TaxDeducted) 
              ))) &lt; 0.001)" id="a_RIM-PTNR-PARTNERSHIP-STMT.15" diagnostics="errorCode.RIM-PTNR-PARTNERSHIP-STMT.15 transactional.RIM-PTNR-PARTNERSHIP-STMT.15 transactional.en.RIM-PTNR-PARTNERSHIP-STMT.15 ">If [Partnership statement] is present [N1.25] must be equal to the sum of [7.17], [7.29] and [1.22].
</sch:assert>
        <sch:assert test="(math:abs((sum(ptr:PartnershipInformation/ptr:ForeignTaxPaid)) - (sum(../../ptr:PartnershipForeign/ptr:ForeignIncomeSavingsLandProperty/ptr:TotalForeignTax))) &lt; 0.001)" id="a_RIM-PTNR-PARTNERSHIP-STMT.20" diagnostics="errorCode.RIM-PTNR-PARTNERSHIP-STMT.20 transactional.RIM-PTNR-PARTNERSHIP-STMT.20 transactional.en.RIM-PTNR-PARTNERSHIP-STMT.20 ">If [Partnership statement] is present [N1.28] must be equal to [2.8].</sch:assert>
        <sch:assert test="(math:abs((sum(ptr:PartnershipInformation/ptr:PartnershipCharges)) - (sum(../ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:NetPartnershipCharges))) &lt; 0.001)" id="a_RIM-PTNR-PARTNERSHIP-STMT.18" diagnostics="errorCode.RIM-PTNR-PARTNERSHIP-STMT.18 transactional.RIM-PTNR-PARTNERSHIP-STMT.18 transactional.en.RIM-PTNR-PARTNERSHIP-STMT.18 ">If [Partnership statement] is present [N1.29] must be equal to [3.117].</sch:assert>
        <sch:assert test="(math:abs((sum(ptr:PartnershipInformation/ptr:TotalDisposalChargeableAssets)) - (sum(../../ptr:PartnershipChargeableAssets/ptr:TotalProceeds))) &lt; 0.001)" id="a_RIM-PTNR-PARTNERSHIP-STMT.19" diagnostics="errorCode.RIM-PTNR-PARTNERSHIP-STMT.19 transactional.RIM-PTNR-PARTNERSHIP-STMT.19 transactional.en.RIM-PTNR-PARTNERSHIP-STMT.19 ">If [Partnership statement] is present [N1.30] must be equal to [4.1].</sch:assert>
        <sch:assert test="(math:abs((sum(ptr:PartnershipInformation/ptr:ChangeOfBasis)) - (sum(../ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:AdjustmentsForTaxableProfitOrLoss/ptr:ChangeOfBasis))) &lt; 0.001)" id="a_RIM-PTNR-PARTNERSHIP-STMT.21" diagnostics="errorCode.RIM-PTNR-PARTNERSHIP-STMT.21 transactional.RIM-PTNR-PARTNERSHIP-STMT.21 transactional.en.RIM-PTNR-PARTNERSHIP-STMT.21 ">If [Partnership statement] is present [N1.11A] must be equal to [3.82].</sch:assert>
        <sch:assert test="(math:abs((sum(ptr:PartnershipInformation/ptr:TaxedSavingsAtLowerDividendRate)) - (sum(../../ptr:PartnershipSavings/ptr:Dividends/ptr:TotalDividends))) &lt; 0.001)" id="a_RIM-PTNR-PARTNERSHIP-STMT.22" diagnostics="errorCode.RIM-PTNR-PARTNERSHIP-STMT.22 transactional.RIM-PTNR-PARTNERSHIP-STMT.22 transactional.en.RIM-PTNR-PARTNERSHIP-STMT.22 ">If [Partnership statement] is present [N1.22A] must be equal to [7.23].</sch:assert>
        <sch:assert test="(math:abs((sum(ptr:PartnershipInformation/ptr:ForeignDividends)) - (sum(../../ptr:PartnershipForeign/ptr:ForeignIncomeSavingsLandProperty/ptr:TotalDividendsIncomeRemittable))) &lt; 0.001)" id="a_RIM-PTNR-PARTNERSHIP-STMT.24" diagnostics="errorCode.RIM-PTNR-PARTNERSHIP-STMT.24 transactional.RIM-PTNR-PARTNERSHIP-STMT.24 transactional.en.RIM-PTNR-PARTNERSHIP-STMT.24 ">If [Partnership statement] is present [N1.14A] must be equal to [2.6A].</sch:assert>
        <sch:assert test="((sum(ptr:PartnershipInformation/ptr:ResidentialFinanceCostsUK)) - (sum(../../ptr:PartnershipLandProperty/ptr:Property/ptr:ResidentialFinanceCosts)) &lt; 0.001)" id="a_RIM-PTNR-PARTNERSHIP-STMT.25" diagnostics="errorCode.RIM-PTNR-PARTNERSHIP-STMT.25 transactional.RIM-PTNR-PARTNERSHIP-STMT.25 transactional.en.RIM-PTNR-PARTNERSHIP-STMT.25 ">If [Partnership statement] is present [N1.26] must be less than or equal to [1.40].</sch:assert>
        <sch:assert test="((sum(ptr:PartnershipInformation/ptr:ResidentialFinanceCostsForeign)) - (sum(../../ptr:PartnershipForeign/ptr:ForeignIncomeSavingsLandProperty/ptr:ResidentialFinanceCosts)) &lt; 0.001)" id="a_RIM-PTNR-PARTNERSHIP-STMT.26" diagnostics="errorCode.RIM-PTNR-PARTNERSHIP-STMT.26 transactional.RIM-PTNR-PARTNERSHIP-STMT.26 transactional.en.RIM-PTNR-PARTNERSHIP-STMT.26 ">If [Partnership statement] is present [N1.27] must be less than or equal to [2.10A].</sch:assert>
        <sch:assert test="((math:abs(sum(ptr:PartnershipInformation/ptr:ResidentialFinanceCostsUK) - sum(ptr:PartnerDetails/ptr:ResidentialFinanceCostsUK))) - (1.00) &lt; 0.001)" id="a_RIM-PTNR-PARTNERSHIP-STMT.27" diagnostics="errorCode.RIM-PTNR-PARTNERSHIP-STMT.27 transactional.RIM-PTNR-PARTNERSHIP-STMT.27 transactional.en.RIM-PTNR-PARTNERSHIP-STMT.27 ">The total of all iterations of [N2.26] must equal [N1.26] +/- £1 tolerance.</sch:assert>
        <sch:assert test="((math:abs(sum(ptr:PartnershipInformation/ptr:ResidentialFinanceCostsForeign) - sum(ptr:PartnerDetails/ptr:ResidentialFinanceCostsForeign))) - (1.00) &lt; 0.001)" id="a_RIM-PTNR-PARTNERSHIP-STMT.28" diagnostics="errorCode.RIM-PTNR-PARTNERSHIP-STMT.28 transactional.RIM-PTNR-PARTNERSHIP-STMT.28 transactional.en.RIM-PTNR-PARTNERSHIP-STMT.28 ">The total of all iterations of [N2.27] must equal [N1.27] +/- £1 tolerance.</sch:assert>
        <sch:assert test="((math:abs(sum(ptr:PartnershipInformation/ptr:TradeProfit) - sum(ptr:PartnerDetails/ptr:TradeProfit))) - (1.00) &lt; 0.001)" id="a_PSF-NET-PROFIT-FOR-YEAR.0" diagnostics="errorCode.PSF-NET-PROFIT-FOR-YEAR.0 transactional.PSF-NET-PROFIT-FOR-YEAR.0 transactional.en.PSF-NET-PROFIT-FOR-YEAR.0 ">The sum of all iterations of [N2.11] must be equal to [N1.11] +/- £1 tolerance.</sch:assert>
        <sch:assert test="((math:abs(sum(ptr:PartnershipInformation/ptr:TradeLoss) - sum(ptr:PartnerDetails/ptr:TradeLoss))) - (1.00) &lt; 0.001)" id="a_PSF-ALLOWABLE-LOSS-FOR-YEAR.0" diagnostics="errorCode.PSF-ALLOWABLE-LOSS-FOR-YEAR.0 transactional.PSF-ALLOWABLE-LOSS-FOR-YEAR.0 transactional.en.PSF-ALLOWABLE-LOSS-FOR-YEAR.0 ">The sum of all iterations of [N2.12] must be equal to [N1.12] +/- £1 tolerance.</sch:assert>
        <sch:assert test="((math:abs(sum(ptr:PartnershipInformation/ptr:UntaxedUKsavingsIncome) - sum(ptr:PartnerDetails/ptr:UKsavingsIncome))) - (1.00) &lt; 0.001)" id="a_PSF-TOTAL-UNTAXED-INTEREST.0" diagnostics="errorCode.PSF-TOTAL-UNTAXED-INTEREST.0 transactional.PSF-TOTAL-UNTAXED-INTEREST.0 transactional.en.PSF-TOTAL-UNTAXED-INTEREST.0 ">The sum of all iterations of [N2.13] must be equal to [N1.13] +/- £1 tolerance.</sch:assert>
        <sch:assert test="((math:abs(sum(ptr:PartnershipInformation/ptr:UntaxedForeignSavingsIncome) - sum(ptr:PartnerDetails/ptr:UntaxedForeignSavingsIncome))) - (1.00) &lt; 0.001)" id="a_PSF-UNTAXED-FOREIGN-SAVINGS.0" diagnostics="errorCode.PSF-UNTAXED-FOREIGN-SAVINGS.0 transactional.PSF-UNTAXED-FOREIGN-SAVINGS.0 transactional.en.PSF-UNTAXED-FOREIGN-SAVINGS.0 ">The sum of all iterations of [N2.14] must be equal to [N1.14] +/- £1 tolerance.</sch:assert>
        <sch:assert test="((math:abs(sum(ptr:PartnershipInformation/ptr:OtherUntaxedUKincome) - sum(ptr:PartnerDetails/ptr:OtherUntaxedUKincome))) - (1.00) &lt; 0.001)" id="a_PSF-OTHER-UNTAXED-UK-INCOME.0" diagnostics="errorCode.PSF-OTHER-UNTAXED-UK-INCOME.0 transactional.PSF-OTHER-UNTAXED-UK-INCOME.0 transactional.en.PSF-OTHER-UNTAXED-UK-INCOME.0 ">The sum of all iterations of [N2.15] must be equal to [N1.15] +/- £1 tolerance.</sch:assert>
        <sch:assert test="((math:abs(sum(ptr:PartnershipInformation/ptr:LossFromOtherUntaxedUKincome) - sum(ptr:PartnerDetails/ptr:LossFromOtherUntaxedUKincome))) - (1.00) &lt; 0.001)" id="a_PSF-OTHER-UNTAXED-UK-INC-LOSS.0" diagnostics="errorCode.PSF-OTHER-UNTAXED-UK-INC-LOSS.0 transactional.PSF-OTHER-UNTAXED-UK-INC-LOSS.0 transactional.en.PSF-OTHER-UNTAXED-UK-INC-LOSS.0 ">The sum of all iterations of [N2.16] must be equal to [N1.16] +/- £1 tolerance.</sch:assert>
        <sch:assert test="((math:abs(sum(ptr:PartnershipInformation/ptr:IncomeFromLandAndPropertyAbroad) - sum(ptr:PartnerDetails/ptr:IncomeFromLandAndPropertyAbroad))) - (1.00) &lt; 0.001)" id="a_PSF-OTHER-UNTAXED-FOREIGN-INC.0" diagnostics="errorCode.PSF-OTHER-UNTAXED-FOREIGN-INC.0 transactional.PSF-OTHER-UNTAXED-FOREIGN-INC.0 transactional.en.PSF-OTHER-UNTAXED-FOREIGN-INC.0 ">The sum of all iterations of [N2.17] must be equal to [N1.17] +/- £1 tolerance.</sch:assert>
        <sch:assert test="((math:abs(sum(ptr:PartnershipInformation/ptr:IncomeFromOffshoreFunds) - sum(ptr:PartnerDetails/ptr:IncomeFromOffshoreFunds))) - (1.00) &lt; 0.001)" id="a_PSF-INCOME-OFFSHORE-FUNDS.0" diagnostics="errorCode.PSF-INCOME-OFFSHORE-FUNDS.0 transactional.PSF-INCOME-OFFSHORE-FUNDS.0 transactional.en.PSF-INCOME-OFFSHORE-FUNDS.0 ">The sum of all iterations of [N2.18] must be equal to [N1.18] +/- £1 tolerance.</sch:assert>
        <sch:assert test="((math:abs(sum(ptr:PartnershipInformation/ptr:ProfitLossOnUKlandAndProperty) - sum(ptr:PartnerDetails/ptr:ProfitLossOnUKlandAndProperty))) - (1.00) &lt; 0.001)" id="a_PSF-PPTY-PROFIT-LOSS-FOR-PRD.0" diagnostics="errorCode.PSF-PPTY-PROFIT-LOSS-FOR-PRD.0 transactional.PSF-PPTY-PROFIT-LOSS-FOR-PRD.0 transactional.en.PSF-PPTY-PROFIT-LOSS-FOR-PRD.0 ">The sum of all iterations of [N2.19] must be equal to [N1.19] +/- £1 tolerance.</sch:assert>
        <sch:assert test="((math:abs(sum(ptr:PartnershipInformation/ptr:LossOnForeignLetProperty) - sum(ptr:PartnerDetails/ptr:LossOnForeignLetProperty))) - (1.00) &lt; 0.001)" id="a_PSF-FOREIGN-LET-PROPERTY-LOSS.0" diagnostics="errorCode.PSF-FOREIGN-LET-PROPERTY-LOSS.0 transactional.PSF-FOREIGN-LET-PROPERTY-LOSS.0 transactional.en.PSF-FOREIGN-LET-PROPERTY-LOSS.0 ">The sum of all iterations of [N2.21] must be equal to [N1.21] +/- £1 tolerance.</sch:assert>
        <sch:assert test="((math:abs(sum(ptr:PartnershipInformation/ptr:TaxedSavings) - sum(ptr:PartnerDetails/ptr:TaxedSavings))) - (1.00) &lt; 0.001)" id="a_PSF-TOTAL-TAXED-SAVINGS.0" diagnostics="errorCode.PSF-TOTAL-TAXED-SAVINGS.0 transactional.PSF-TOTAL-TAXED-SAVINGS.0 transactional.en.PSF-TOTAL-TAXED-SAVINGS.0 ">The sum of all iterations of [N2.22] must be equal to [N1.22] +/- £1 tolerance.</sch:assert>
        <sch:assert test="((math:abs(sum(ptr:PartnershipInformation/ptr:OtherTaxedIncome) - sum(ptr:PartnerDetails/ptr:OtherTaxedIncome))) - (1.00) &lt; 0.001)" id="a_PSF-OTHER-OI-BEFORE-TAX-DED.0" diagnostics="errorCode.PSF-OTHER-OI-BEFORE-TAX-DED.0 transactional.PSF-OTHER-OI-BEFORE-TAX-DED.0 transactional.en.PSF-OTHER-OI-BEFORE-TAX-DED.0 ">The sum of all iterations of [N2.23] must be equal to [N1.23] +/- £1 tolerance.</sch:assert>
        <sch:assert test="((math:abs(sum(ptr:PartnershipInformation/ptr:CIS25deductions) - sum(ptr:PartnerDetails/ptr:CIS25deductions))) - (1.00) &lt; 0.001)" id="a_PSF-SUB-CON-DEDUCTION.0" diagnostics="errorCode.PSF-SUB-CON-DEDUCTION.0 transactional.PSF-SUB-CON-DEDUCTION.0 transactional.en.PSF-SUB-CON-DEDUCTION.0 ">The sum of all iterations of [N2.24] must be equal to [N1.24] +/- £1 tolerance.</sch:assert>
        <sch:assert test="((math:abs(sum(ptr:PartnershipInformation/ptr:UKincomeTax) - sum(ptr:PartnerDetails/ptr:UKincomeTax))) - (1.00) &lt; 0.001)" id="a_PSF-UK-INCOME-TAX.0" diagnostics="errorCode.PSF-UK-INCOME-TAX.0 transactional.PSF-UK-INCOME-TAX.0 transactional.en.PSF-UK-INCOME-TAX.0 ">The sum of all iterations of [N2.25] must be equal to [N1.25] +/- £1 tolerance.</sch:assert>
        <sch:assert test="((math:abs(sum(ptr:PartnershipInformation/ptr:ForeignTaxPaid) - sum(ptr:PartnerDetails/ptr:ForeignTaxPaid))) - (1.00) &lt; 0.001)" id="a_PSF-TOTAL-FOREIGN-TAX-PAID.0" diagnostics="errorCode.PSF-TOTAL-FOREIGN-TAX-PAID.0 transactional.PSF-TOTAL-FOREIGN-TAX-PAID.0 transactional.en.PSF-TOTAL-FOREIGN-TAX-PAID.0 ">The sum of all iterations of [N2.28] must be equal to [N1.28] +/- £1 tolerance.</sch:assert>
        <sch:assert test="((math:abs(sum(ptr:PartnershipInformation/ptr:PartnershipCharges) - sum(ptr:PartnerDetails/ptr:PartnershipCharges))) - (1.00) &lt; 0.001)" id="a_PSF-NET-PSHIP-CHARGES-PAID.0" diagnostics="errorCode.PSF-NET-PSHIP-CHARGES-PAID.0 transactional.PSF-NET-PSHIP-CHARGES-PAID.0 transactional.en.PSF-NET-PSHIP-CHARGES-PAID.0 ">The sum of all iterations of [N2.29] must be equal to [N1.29] +/- £1 tolerance.</sch:assert>
        <sch:assert test="((math:abs(sum(ptr:PartnershipInformation/ptr:TotalDisposalChargeableAssets) - sum(ptr:PartnerDetails/ptr:DisposalOfChargeableAssets))) - (1.00) &lt; 0.001)" id="a_PSF-TOT-DISPOSAL-CHRGBLE-ASSET.0" diagnostics="errorCode.PSF-TOT-DISPOSAL-CHRGBLE-ASSET.0 transactional.PSF-TOT-DISPOSAL-CHRGBLE-ASSET.0 transactional.en.PSF-TOT-DISPOSAL-CHRGBLE-ASSET.0 ">The sum of all iterations of [N2.30] must be equal to [N1.30] +/- £1 tolerance.</sch:assert>
        <sch:assert test="((math:abs(sum(ptr:PartnershipInformation/ptr:ChangeOfBasis) - sum(ptr:PartnerDetails/ptr:ChangeOfBasis))) - (1.00) &lt; 0.001)" id="a_PSF3-CHANGE-OF-BASIS-ADJ.0" diagnostics="errorCode.PSF3-CHANGE-OF-BASIS-ADJ.0 transactional.PSF3-CHANGE-OF-BASIS-ADJ.0 transactional.en.PSF3-CHANGE-OF-BASIS-ADJ.0 ">The sum of all iterations of [N2.11A] must be equal to [N1.11A] +/- £1 tolerance.</sch:assert>
        <sch:assert test="((math:abs(sum(ptr:PartnershipInformation/ptr:TaxedSavingsAtLowerDividendRate) - sum(ptr:PartnerDetails/ptr:TaxedSavingsAtLowerDividendRate))) - (1.00) &lt; 0.001)" id="a_PSF3-TOT-SCHF-TAXED-SAVINGS.0" diagnostics="errorCode.PSF3-TOT-SCHF-TAXED-SAVINGS.0 transactional.PSF3-TOT-SCHF-TAXED-SAVINGS.0 transactional.en.PSF3-TOT-SCHF-TAXED-SAVINGS.0 ">The sum of all iterations of [N2.22A] must be equal to [N1.22A] +/- £1 tolerance.</sch:assert>
        <sch:assert test="((math:abs(sum(ptr:PartnershipInformation/ptr:ForeignDividends) - sum(ptr:PartnerDetails/ptr:OverseasDividends))) - (1.00) &lt; 0.001)" id="a_PSF4-FOREIGN-DIVIDENDS-AMOUNT.0" diagnostics="errorCode.PSF4-FOREIGN-DIVIDENDS-AMOUNT.0 transactional.PSF4-FOREIGN-DIVIDENDS-AMOUNT.0 transactional.en.PSF4-FOREIGN-DIVIDENDS-AMOUNT.0 ">The sum of all iterations of [N2.14A] must be equal to [N1.14A] +/- £1 tolerance.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p49">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:OtherInformation/ptr:TaxPayerAddress">
        <sch:assert test="not(ptr:Line[1])
                or
              ptr:Line[2]" id="a_PTF-TAXPAYER-ADDRESS.0" diagnostics="errorCode.PTF-TAXPAYER-ADDRESS.0 transactional.PTF-TAXPAYER-ADDRESS.0 transactional.en.PTF-TAXPAYER-ADDRESS.0 ">If A11 is present, A12 must be present.</sch:assert>
        <sch:assert test="not(ptr:ShortLine[1])
                or
              (
                ptr:Line[1]
                  and
                ptr:Line[2]
                  and
                ptr:Line[3]
              )" id="a_PTF-TAXPAYER-ADDRESS.1" diagnostics="errorCode.PTF-TAXPAYER-ADDRESS.1 transactional.PTF-TAXPAYER-ADDRESS.1 transactional.en.PTF-TAXPAYER-ADDRESS.1 ">If A14 is present, then A11, A12 and A13 must be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p50">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership/ptr:OtherInformation/ptr:TaxAvoidanceSchemes">
        <sch:assert test="ptr:Reference
                or
              ptr:TaxYearEnd" id="a_RIM-PTNR-TAX-AVOIDANCE-SCHEMES.0" diagnostics="errorCode.RIM-PTNR-TAX-AVOIDANCE-SCHEMES.0 transactional.RIM-PTNR-TAX-AVOIDANCE-SCHEMES.0 transactional.en.RIM-PTNR-TAX-AVOIDANCE-SCHEMES.0 ">Each repetition of [Tax avoidance schemes] must contain at least one of either [10.2] or [10.3].</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p4">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:Partnership">
        <sch:assert test="not(ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:TurnoverBelowLimit/ptr:Turnover or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:TurnoverBelowLimit/ptr:Expenses) or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:TurnoverBelowLimit/ptr:NetProfitOrLoss" id="a_PTP-BUSINESS-NET-PROFIT-LOSS.global.0" diagnostics="errorCode.PTP-BUSINESS-NET-PROFIT-LOSS.global.0 transactional.PTP-BUSINESS-NET-PROFIT-LOSS.global.0 transactional.en.PTP-BUSINESS-NET-PROFIT-LOSS.global.0 ">[3.26] should be present if [3.24] or [3.25]</sch:assert>
        <sch:assert test="not(ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:SalesBusinessIncome or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:CostOfSales or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:SubcontractorCosts or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:OtherDirectCosts) or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:GrossProfitLoss" id="a_PTP-GROSS-PROFIT-LOSS.global.1" diagnostics="errorCode.PTP-GROSS-PROFIT-LOSS.global.1 transactional.PTP-GROSS-PROFIT-LOSS.global.1 transactional.en.PTP-GROSS-PROFIT-LOSS.global.1 ">[3.49] should be present if [3.29] or [3.46] or [3.47] or [3.48]</sch:assert>
        <sch:assert test="not(ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:EmployeeCosts or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:PremisesCosts or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:Repairs or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:GeneralAdministrativeExpenses or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:MotorExpenses or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:TravelAndSubsistence or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:AdvertisingEtc or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:LegalAndProfessionalCosts or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:BadDebts or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:Interest or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:OtherFinanceCharges or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:DepreciationAndLoss or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:OtherExpenses) or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:TotalExpenses" id="a_PTP-TOTAL-EXPENDITURE.global.2" diagnostics="errorCode.PTP-TOTAL-EXPENDITURE.global.2 transactional.PTP-TOTAL-EXPENDITURE.global.2 transactional.en.PTP-TOTAL-EXPENDITURE.global.2 ">[3.64] should be present if [3.51] or [3.52] or [3.53] or [3.54] or [3.55] or [3.56] or [3.57] or [3.58] or [3.59] or [3.60] or [3.61] or [3.62] or [3.63]</sch:assert>
        <sch:assert test="not(ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:GrossProfitLoss or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:OtherIncomeProfits or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:TotalExpenses) or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:NetProfitOrLoss" id="a_PTP3-NET-PROFIT-LOSS.global.3" diagnostics="errorCode.PTP3-NET-PROFIT-LOSS.global.3 transactional.PTP3-NET-PROFIT-LOSS.global.3 transactional.en.PTP3-NET-PROFIT-LOSS.global.3 ">[3.65] should be present if [3.49] or [3.50] or [3.64]</sch:assert>
        <sch:assert test="not(ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:DisallowableTravelExpenses or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:DisallowableAdvertisingExpenses or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:DisallowableLegalProfessionalCost or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:DisallowableBadDebts or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:DisallowableInterest or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:DisallowableOtherFinanceCharges or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:DisallowableDepreciation or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:DisallowableOtherExpenses) or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:TaxAdjustments/ptr:AdditionsToNetProfit/ptr:DisallowableExpenses" id="a_PTP-DISALLOW-EXPENDITURE.global.4a" diagnostics="errorCode.PTP-DISALLOW-EXPENDITURE.global.4a transactional.PTP-DISALLOW-EXPENDITURE.global.4a transactional.en.PTP-DISALLOW-EXPENDITURE.global.4a ">[3.66] should be present if [3.38] or [3.39] or [3.40] or [3.41] or [3.42] or [3.43] or [3.44] or [3.45]</sch:assert>
        <sch:assert test="not(ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:DisallowableCostOfSales or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:DisallowableSubContractorCosts or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:DisallowableDirectCosts or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:DisallowableEmployeeCosts or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:DisallowablePremisesCosts or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:DisallowableRepairs or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:DisallowableAdminExpenses or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:DisallowableMotorExpenses) or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:TaxAdjustments/ptr:AdditionsToNetProfit/ptr:DisallowableExpenses" id="a_PTP-DISALLOW-EXPENDITURE.global.4b" diagnostics="errorCode.PTP-DISALLOW-EXPENDITURE.global.4b transactional.PTP-DISALLOW-EXPENDITURE.global.4b transactional.en.PTP-DISALLOW-EXPENDITURE.global.4b ">[3.66] should be present if [3.30] or [3.31] or [3.32] or [3.33] or [3.34] or [3.35] or [3.36] or [3.37]</sch:assert>
        <sch:assert test="not(ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:TaxAdjustments/ptr:AdditionsToNetProfit/ptr:DisallowableExpenses or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:TaxAdjustments/ptr:AdditionsToNetProfit/ptr:GoodsTakenForPersonalUse or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:TaxAdjustments/ptr:AdditionsToNetProfit/ptr:BalancingCharge) or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:TaxAdjustments/ptr:AdditionsToNetProfit/ptr:TotalAdditionsToNetProfit" id="a_PTP-ADDITIONS-TO-NET-PROFIT.global.5" diagnostics="errorCode.PTP-ADDITIONS-TO-NET-PROFIT.global.5 transactional.PTP-ADDITIONS-TO-NET-PROFIT.global.5 transactional.en.PTP-ADDITIONS-TO-NET-PROFIT.global.5 ">[3.69] should be present if [3.66] or [3.67] or [3.68]</sch:assert>
        <sch:assert test="not(ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:TaxAdjustments/ptr:DeductionsFromNetProfit/ptr:CapitalAllowances or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:TaxAdjustments/ptr:DeductionsFromNetProfit/ptr:Deductions) or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:TaxAdjustments/ptr:DeductionsFromNetProfit/ptr:TotalDeductionsFromNetProfit" id="a_PTP-TOTAL-DEDUCTIONS.global.6" diagnostics="errorCode.PTP-TOTAL-DEDUCTIONS.global.6 transactional.PTP-TOTAL-DEDUCTIONS.global.6 transactional.en.PTP-TOTAL-DEDUCTIONS.global.6 ">[3.72] should be present if [3.70] or [3.71]</sch:assert>
        <sch:assert test="not(ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:IncomeAndExpenses/ptr:NetProfitOrLoss or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:TaxAdjustments/ptr:AdditionsToNetProfit/ptr:TotalAdditionsToNetProfit or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:TaxAdjustments/ptr:DeductionsFromNetProfit/ptr:TotalDeductionsFromNetProfit) or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:TaxAdjustments/ptr:NetProfitLoss" id="a_PTP4-NET-BUSINESS-PROFIT-LOSS.global.7" diagnostics="errorCode.PTP4-NET-BUSINESS-PROFIT-LOSS.global.7 transactional.PTP4-NET-BUSINESS-PROFIT-LOSS.global.7 transactional.en.PTP4-NET-BUSINESS-PROFIT-LOSS.global.7 ">[3.73] should be present if [3.65] or [3.69] or [3.72]</sch:assert>
        <sch:assert test="not((sum(ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:TurnoverBelowLimit/ptr:NetProfitOrLoss) &gt; 0) or (sum(ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:TaxAdjustments/ptr:NetProfitLoss) &gt; 0)) or ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:AdjustmentsForTaxableProfitOrLoss/ptr:NetProfit" id="a_PTP-NET-PROFIT-FOR-YEAR.global.8" diagnostics="errorCode.PTP-NET-PROFIT-FOR-YEAR.global.8 transactional.PTP-NET-PROFIT-FOR-YEAR.global.8 transactional.en.PTP-NET-PROFIT-FOR-YEAR.global.8 ">[3.83] should be present if ([3.26] exceeds 0) or ([3.73] exceeds 0)</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p52">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipLandProperty/ptr:PartnershipDetails/ptr:ReturnPeriodEnd">
        <sch:assert test="not(../ptr:ReturnPeriodStart)
                  or
                not((.))
                  or
                (round(date:seconds(normalize-space(../ptr:ReturnPeriodStart)) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))" id="a_PLP-PERIOD-END-DATE.0" diagnostics="errorCode.PLP-PERIOD-END-DATE.0 transactional.PLP-PERIOD-END-DATE.0 transactional.en.PLP-PERIOD-END-DATE.0 ">[1.2] should be on or after [1.1]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p53">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipLandProperty/ptr:Property/ptr:Income/ptr:TotalIncome">
        <sch:assert test="(math:abs((.) - ((sum(../ptr:RentsEtc/ptr:Income) + sum(../ptr:ChargeablePremiums) + sum(../ptr:ReversePremiums)))) &lt; 0.001)" id="a_PLP3-PPTY-TOTAL-INCOME.0" diagnostics="errorCode.PLP3-PPTY-TOTAL-INCOME.0 transactional.PLP3-PPTY-TOTAL-INCOME.0 transactional.en.PLP3-PPTY-TOTAL-INCOME.0 ">[1.24] is valid if and only if this equals ( The sum of [1.21], [1.23], and [1.23A] )</sch:assert>
        <sch:assert test="../../../ptr:PartnershipDetails/ptr:ReturnPeriodStart" id="a_PLP3-PPTY-TOTAL-INCOME.1" diagnostics="errorCode.PLP3-PPTY-TOTAL-INCOME.1 transactional.PLP3-PPTY-TOTAL-INCOME.1 transactional.en.PLP3-PPTY-TOTAL-INCOME.1 ">If Total income is present the following should be true: [1.1]</sch:assert>
        <sch:assert test="not(../../../../ptr:Partnership/ptr:PartnershipStatement/ptr:PartnershipInformation/ptr:UsesCTrules) or ../ptr:RentsEtc/ptr:TraditionalAccounting" id="a_PLP3-PPTY-TOTAL-INCOME.2" diagnostics="errorCode.PLP3-PPTY-TOTAL-INCOME.2 transactional.PLP3-PPTY-TOTAL-INCOME.2 transactional.en.PLP3-PPTY-TOTAL-INCOME.2 ">[1.22A] should be present if [N1.4] is present and [1.24] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p54">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipLandProperty/ptr:Property/ptr:Expenses/ptr:TotalExpenses">
        <sch:assert test="(math:abs((.) - ((sum(../ptr:RentEtc) + sum(../ptr:RepairsEtc) + sum(../ptr:Finance) + sum(../ptr:LegalAndProfessionalCosts) + sum(../ptr:CostOfServicesProvided) + sum(../ptr:OtherExpenses)))) &lt; 0.001)" id="a_PLP-PPTY-TOTAL-EXPENDITURE.0" diagnostics="errorCode.PLP-PPTY-TOTAL-EXPENDITURE.0 transactional.PLP-PPTY-TOTAL-EXPENDITURE.0 transactional.en.PLP-PPTY-TOTAL-EXPENDITURE.0 ">[1.31] should equal ( The sum of [1.25], [1.26], [1.27], [1.28], [1.29], and [1.30] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p55">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipLandProperty/ptr:Property/ptr:NetProfitLoss">
        <sch:assert test="(math:abs((.) - ((sum(../ptr:Income/ptr:TotalIncome) - sum(../ptr:Expenses/ptr:TotalExpenses)))) &lt; 0.001)" id="a_PLP-PPTY-NET-PROFIT-LOSS.0" diagnostics="errorCode.PLP-PPTY-NET-PROFIT-LOSS.0 transactional.PLP-PPTY-NET-PROFIT-LOSS.0 transactional.en.PLP-PPTY-NET-PROFIT-LOSS.0 ">[1.32] should equal ( [1.24] minus [1.31] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p56">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipLandProperty/ptr:Property/ptr:TaxAdjustments/ptr:AdditionsToNetProfit/ptr:TotalAdditions">
        <sch:assert test="(math:abs((.) - ((sum(../ptr:PrivateUse) + sum(../ptr:BalancingCharges)))) &lt; 0.001)" id="a_PLP-PPTY-TOTAL-ADDITIONS.0" diagnostics="errorCode.PLP-PPTY-TOTAL-ADDITIONS.0 transactional.PLP-PPTY-TOTAL-ADDITIONS.0 transactional.en.PLP-PPTY-TOTAL-ADDITIONS.0 ">[1.35] should equal ( [1.33] plus [1.34] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p58">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipLandProperty/ptr:Property/ptr:TaxAdjustments/ptr:DeductionsFromNetProfit/ptr:AnnualInvestmentAllowance">
        <sch:assert test="../../../ptr:Income/ptr:RentsEtc/ptr:TraditionalAccounting" id="a_PLP-ANNUAL-INV-ALLCE-AMT.1" diagnostics="errorCode.PLP-ANNUAL-INV-ALLCE-AMT.1 transactional.PLP-ANNUAL-INV-ALLCE-AMT.1 transactional.en.PLP-ANNUAL-INV-ALLCE-AMT.1 ">[1.35A] should not be present if [1.22A] is not present</sch:assert>
        <sch:assert test=". &lt;= 1500000" id="a_PLP-ANNUAL-INV-ALLCE-AMT.0" diagnostics="errorCode.PLP-ANNUAL-INV-ALLCE-AMT.0 transactional.PLP-ANNUAL-INV-ALLCE-AMT.0 transactional.en.PLP-ANNUAL-INV-ALLCE-AMT.0 ">[1.35A] is valid only if this does not exceed [£1,500,000]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p59">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipLandProperty/ptr:Property/ptr:TaxAdjustments/ptr:DeductionsFromNetProfit/ptr:TotalDeductions">
        <sch:assert test="(math:abs((.) - ((sum(../ptr:AnnualInvestmentAllowance)
			+ sum(../ptr:ElectricChargePointAllowance)
			+ sum(../ptr:TheStructuresAndBuildingsAllowance)
			+ sum(../ptr:FreeportAndInvestmentZonesStructuresAndBuildingsAllowance)
			+ sum(../ptr:ZeroEmissionCarAllowance)
			+ sum(../ptr:CapitalAllowances)
		       	+ sum(../ptr:CostsOfReplacingDomesticItems)))) &lt; 0.001)" id="a_PLP-PPTY-TOTAL-DEDUCTIONS.0" diagnostics="errorCode.PLP-PPTY-TOTAL-DEDUCTIONS.0 transactional.PLP-PPTY-TOTAL-DEDUCTIONS.0 transactional.en.PLP-PPTY-TOTAL-DEDUCTIONS.0 ">[1.38] is valid only if this equals ( The sum of [1.35A], [1.35B], [1.35C], [1.35D], [1.35E], [1.36], and [1.37] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p57">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipLandProperty/ptr:Property/ptr:TaxAdjustments/ptr:DeductionsFromNetProfit">
        <sch:assert test="not(ptr:AnnualInvestmentAllowance) or ptr:TotalDeductions" id="a_RIM-PLP-NET-PROFIT-DEDUCTIONS.0" diagnostics="errorCode.RIM-PLP-NET-PROFIT-DEDUCTIONS.0 transactional.RIM-PLP-NET-PROFIT-DEDUCTIONS.0 transactional.en.RIM-PLP-NET-PROFIT-DEDUCTIONS.0 ">[1.38] should be present if [1.35A] is present</sch:assert>
        <sch:assert test="not(ptr:ElectricChargePointAllowance) or ptr:TotalDeductions" id="a_RIM-PLP-NET-PROFIT-DEDUCTIONS.1" diagnostics="errorCode.RIM-PLP-NET-PROFIT-DEDUCTIONS.1 transactional.RIM-PLP-NET-PROFIT-DEDUCTIONS.1 transactional.en.RIM-PLP-NET-PROFIT-DEDUCTIONS.1 ">[1.38] should be present if [1.35B] is present</sch:assert>
        <sch:assert test="not(ptr:TheStructuresAndBuildingsAllowance) or ptr:TotalDeductions" id="a_RIM-PLP-NET-PROFIT-DEDUCTIONS.2" diagnostics="errorCode.RIM-PLP-NET-PROFIT-DEDUCTIONS.2 transactional.RIM-PLP-NET-PROFIT-DEDUCTIONS.2 transactional.en.RIM-PLP-NET-PROFIT-DEDUCTIONS.2 ">[1.38] should be present if [1.35C] is present</sch:assert>
        <sch:assert test="not(ptr:FreeportAndInvestmentZonesStructuresAndBuildingsAllowance) or ptr:TotalDeductions" id="a_RIM-PLP-NET-PROFIT-DEDUCTIONS.3" diagnostics="errorCode.RIM-PLP-NET-PROFIT-DEDUCTIONS.3 transactional.RIM-PLP-NET-PROFIT-DEDUCTIONS.3 transactional.en.RIM-PLP-NET-PROFIT-DEDUCTIONS.3 ">[1.38] should be present if [1.35D] is present</sch:assert>
        <sch:assert test="not(ptr:ZeroEmissionCarAllowance) or ptr:TotalDeductions" id="a_RIM-PLP-NET-PROFIT-DEDUCTIONS.4" diagnostics="errorCode.RIM-PLP-NET-PROFIT-DEDUCTIONS.4 transactional.RIM-PLP-NET-PROFIT-DEDUCTIONS.4 transactional.en.RIM-PLP-NET-PROFIT-DEDUCTIONS.4 ">[1.38] should be present if [1.35E] is present</sch:assert>
        <sch:assert test="not(ptr:CapitalAllowances) or ptr:TotalDeductions" id="a_RIM-PLP-NET-PROFIT-DEDUCTIONS.5" diagnostics="errorCode.RIM-PLP-NET-PROFIT-DEDUCTIONS.5 transactional.RIM-PLP-NET-PROFIT-DEDUCTIONS.5 transactional.en.RIM-PLP-NET-PROFIT-DEDUCTIONS.5 ">[1.38] should be present if [1.36] is present</sch:assert>
        <sch:assert test="not(ptr:CostsOfReplacingDomesticItems) or ptr:TotalDeductions" id="a_RIM-PLP-NET-PROFIT-DEDUCTIONS.6" diagnostics="errorCode.RIM-PLP-NET-PROFIT-DEDUCTIONS.6 transactional.RIM-PLP-NET-PROFIT-DEDUCTIONS.6 transactional.en.RIM-PLP-NET-PROFIT-DEDUCTIONS.6 ">[1.38] should be present if [1.37] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p60">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipLandProperty/ptr:Property/ptr:ProfitLossForReturnPeriod">
        <sch:assert test="../../ptr:PartnershipDetails/ptr:ReturnPeriodStart" id="a_PLP-PPTY-PROFIT-LOSS-FOR-PRD.1" diagnostics="errorCode.PLP-PPTY-PROFIT-LOSS-FOR-PRD.1 transactional.PLP-PPTY-PROFIT-LOSS-FOR-PRD.1 transactional.en.PLP-PPTY-PROFIT-LOSS-FOR-PRD.1 ">If Profit loss for return period is present the following should be true: [1.1]</sch:assert>
        <sch:assert test="(math:abs((.) - (((sum(../ptr:NetProfitLoss) + sum(../ptr:TaxAdjustments/ptr:AdditionsToNetProfit/ptr:TotalAdditions)) - sum(../ptr:TaxAdjustments/ptr:DeductionsFromNetProfit/ptr:TotalDeductions)))) &lt; 0.001)" id="a_PLP-PPTY-PROFIT-LOSS-FOR-PRD.2" diagnostics="errorCode.PLP-PPTY-PROFIT-LOSS-FOR-PRD.2 transactional.PLP-PPTY-PROFIT-LOSS-FOR-PRD.2 transactional.en.PLP-PPTY-PROFIT-LOSS-FOR-PRD.2 ">[1.39] should equal ( ( [1.32] plus [1.35] ) minus [1.38] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p51">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipLandProperty">
        <sch:assert test="not ( ../ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:AccountingPeriodStart )
          or
          (round(date:seconds(normalize-space(../ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:AccountingPeriodStart)) div 86400) = round(date:seconds(normalize-space(ptr:PartnershipDetails/ptr:ReturnPeriodStart)) div 86400))" id="a_PLP-PERIOD-START-DATE.0" diagnostics="errorCode.PLP-PERIOD-START-DATE.0 transactional.PLP-PERIOD-START-DATE.0 transactional.en.PLP-PERIOD-START-DATE.0 ">If [3.4] present then [1.1] must equal [3.4]</sch:assert>
        <sch:assert test="not ( ../ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:AccountingPeriodEnd )
          or
          (round(date:seconds(normalize-space(../ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:AccountingPeriodEnd)) div 86400) = round(date:seconds(normalize-space(ptr:PartnershipDetails/ptr:ReturnPeriodEnd)) div 86400))" id="a_PLP-PERIOD-END-DATE.1" diagnostics="errorCode.PLP-PERIOD-END-DATE.1 transactional.PLP-PERIOD-END-DATE.1 transactional.en.PLP-PERIOD-END-DATE.1 ">If [3.5] present then [1.2] must equal [3.5]</sch:assert>
        <sch:assert test="not(ptr:Property/ptr:Income/ptr:RentsEtc/ptr:Income) or ptr:Property/ptr:Income/ptr:TotalIncome" id="a_PLP3-PPTY-TOTAL-INCOME.global.14" diagnostics="errorCode.PLP3-PPTY-TOTAL-INCOME.global.14 transactional.PLP3-PPTY-TOTAL-INCOME.global.14 transactional.en.PLP3-PPTY-TOTAL-INCOME.global.14 ">[1.24] should be present if [1.21] is present</sch:assert>
        <sch:assert test="not(ptr:Property/ptr:Expenses/ptr:RentEtc or ptr:Property/ptr:Expenses/ptr:RepairsEtc or ptr:Property/ptr:Expenses/ptr:Finance or ptr:Property/ptr:Expenses/ptr:LegalAndProfessionalCosts or ptr:Property/ptr:Expenses/ptr:CostOfServicesProvided or ptr:Property/ptr:Expenses/ptr:OtherExpenses) or ptr:Property/ptr:Expenses/ptr:TotalExpenses" id="a_PLP-PPTY-TOTAL-EXPENDITURE.global.15" diagnostics="errorCode.PLP-PPTY-TOTAL-EXPENDITURE.global.15 transactional.PLP-PPTY-TOTAL-EXPENDITURE.global.15 transactional.en.PLP-PPTY-TOTAL-EXPENDITURE.global.15 ">[1.31] should be present if [1.25] or [1.26] or [1.27] or [1.28] or [1.29] or [1.30]</sch:assert>
        <sch:assert test="not(ptr:Property/ptr:Income/ptr:TotalIncome or ptr:Property/ptr:Expenses/ptr:TotalExpenses) or ptr:Property/ptr:NetProfitLoss" id="a_PLP-PPTY-NET-PROFIT-LOSS.global.16" diagnostics="errorCode.PLP-PPTY-NET-PROFIT-LOSS.global.16 transactional.PLP-PPTY-NET-PROFIT-LOSS.global.16 transactional.en.PLP-PPTY-NET-PROFIT-LOSS.global.16 ">[1.32] should be present if [1.24] or [1.31]</sch:assert>
        <sch:assert test="not(ptr:Property/ptr:TaxAdjustments/ptr:AdditionsToNetProfit/ptr:PrivateUse or ptr:Property/ptr:TaxAdjustments/ptr:AdditionsToNetProfit/ptr:BalancingCharges) or ptr:Property/ptr:TaxAdjustments/ptr:AdditionsToNetProfit/ptr:TotalAdditions" id="a_PLP-PPTY-TOTAL-ADDITIONS.global.17" diagnostics="errorCode.PLP-PPTY-TOTAL-ADDITIONS.global.17 transactional.PLP-PPTY-TOTAL-ADDITIONS.global.17 transactional.en.PLP-PPTY-TOTAL-ADDITIONS.global.17 ">[1.35] should be present if [1.33] or [1.34]</sch:assert>
        <sch:assert test="not(ptr:Property/ptr:NetProfitLoss or ptr:Property/ptr:TaxAdjustments/ptr:AdditionsToNetProfit/ptr:TotalAdditions or ptr:Property/ptr:TaxAdjustments/ptr:DeductionsFromNetProfit/ptr:TotalDeductions) or ptr:Property/ptr:ProfitLossForReturnPeriod" id="a_PLP-PPTY-PROFIT-LOSS-FOR-PRD.global.19" diagnostics="errorCode.PLP-PPTY-PROFIT-LOSS-FOR-PRD.global.19 transactional.PLP-PPTY-PROFIT-LOSS-FOR-PRD.global.19 transactional.en.PLP-PPTY-PROFIT-LOSS-FOR-PRD.global.19 ">[1.39] should be present if [1.32] or [1.35] or [1.38]</sch:assert>
        <sch:assert test="not(ptr:PartnershipDetails/ptr:ReturnPeriodStart) or ptr:PartnershipDetails/ptr:ReturnPeriodEnd" id="a_SA801.0" diagnostics="errorCode.SA801.0 transactional.SA801.0 transactional.en.SA801.0 ">[1.2] should be present if [1.1] is present</sch:assert>
        <sch:assert test="not(ptr:Property/ptr:Income/ptr:ChargeablePremiums) or ptr:Property/ptr:Income/ptr:TotalIncome" id="a_SA801.1" diagnostics="errorCode.SA801.1 transactional.SA801.1 transactional.en.SA801.1 ">[1.24] should be present if [1.23] is present</sch:assert>
        <sch:assert test="not(ptr:Property/ptr:Income/ptr:ReversePremiums) or ptr:Property/ptr:Income/ptr:TotalIncome" id="a_SA801.2" diagnostics="errorCode.SA801.2 transactional.SA801.2 transactional.en.SA801.2 ">[1.24] should be present if [1.23A] is present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p63">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipForeign/ptr:ForeignIncomeSavingsLandProperty/ptr:ReturnPeriodEnd">
        <sch:assert test="not(../ptr:ReturnPeriodStart)
                  or
                not((.))
                  or
                (round(date:seconds(normalize-space(../ptr:ReturnPeriodStart)) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))" id="a_PFI-FOREIGN-PERIOD-END-DATE.0" diagnostics="errorCode.PFI-FOREIGN-PERIOD-END-DATE.0 transactional.PFI-FOREIGN-PERIOD-END-DATE.0 transactional.en.PFI-FOREIGN-PERIOD-END-DATE.0 ">[2.5] should be on or after [2.4]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p64">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipForeign/ptr:ForeignIncomeSavingsLandProperty/ptr:TotalIncomeRemittable">
        <sch:assert test="(math:abs((.) - (sum(../ptr:InterestEtc/ptr:InterestEtcRow/ptr:Gross[not (../ptr:Unremittable = &apos;yes&apos;)]))) &lt; 0.001)" id="a_PFI-UNTAXED-FOREIGN-SAVINGS.0" diagnostics="errorCode.PFI-UNTAXED-FOREIGN-SAVINGS.0 transactional.PFI-UNTAXED-FOREIGN-SAVINGS.0 transactional.en.PFI-UNTAXED-FOREIGN-SAVINGS.0 ">[2.6] must equal total of "Gross of [2.2.1 Country/2.2.2 Unremittable/2.2.3 Gross/2.2.4 Foreign Tax -]" entries with no corresponding tick in "Unremittable tickbox of [2.2.1 Country/2.2.2 Unremittable/2.2.3 Gross/2.2.4 Foreign Tax -]"</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p65">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipForeign/ptr:ForeignIncomeSavingsLandProperty/ptr:TotalDividendsIncomeRemittable">
        <sch:assert test="(math:abs((.) - (sum(../ptr:Dividends/ptr:DividendsRow/ptr:Gross[not (../ptr:Unremittable = &apos;yes&apos;)]))) &lt; 0.001)" id="a_PFI4-UNTAXED-FOREIGN-DIV-TOT.0" diagnostics="errorCode.PFI4-UNTAXED-FOREIGN-DIV-TOT.0 transactional.PFI4-UNTAXED-FOREIGN-DIV-TOT.0 transactional.en.PFI4-UNTAXED-FOREIGN-DIV-TOT.0 ">[2.6A] must equal total of "Gross of [2.2A.1 Country/2.2A.2 Unremittable/2.2A.3 Gross/2.2A.4 Foreign Tax -]" entries with no corresponding tick in "Unremittable tickbox of [2.2A.1 Country/2.2A.2 Unremittable/2.2A.3 Gross/2.2A.4 Foreign Tax -]"</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p66">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipForeign/ptr:ForeignIncomeSavingsLandProperty/ptr:LandProperty/ptr:Gross">
        <sch:assert test="../../../ptr:IncomeLandPropertyAbroad/ptr:TaxableProfit or ../../../ptr:IncomeLandPropertyAbroad/ptr:TotalTaxableProfit" id="a_RIM-PFI-LAND-PPTY-GROSS.0" diagnostics="errorCode.RIM-PFI-LAND-PPTY-GROSS.0 transactional.RIM-PFI-LAND-PPTY-GROSS.0 transactional.en.RIM-PFI-LAND-PPTY-GROSS.0 ">If [2.3.3] is present, [2.28] or [2.31] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p67">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipForeign/ptr:ForeignIncomeSavingsLandProperty/ptr:TotalGross">
        <sch:assert test="(math:abs((.) - (sum(../ptr:LandProperty/ptr:Gross) + sum(../ptr:ChargeablePremiums/ptr:Gross))) &lt; 0.001)" id="a_PFI-OTHER-UNTAXED-FOREIGN-INC.0" diagnostics="errorCode.PFI-OTHER-UNTAXED-FOREIGN-INC.0 transactional.PFI-OTHER-UNTAXED-FOREIGN-INC.0 transactional.en.PFI-OTHER-UNTAXED-FOREIGN-INC.0 ">[2.7] must equal total of ([2.3.3] + [2.3A.3])</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p68">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipForeign/ptr:ForeignIncomeSavingsLandProperty/ptr:TotalForeignTax">
        <sch:assert test="../ptr:TotalIncomeRemittable or ../ptr:TotalDividendsIncomeRemittable or ../ptr:TotalGross" id="a_PFI-TOTAL-FOREIGN-TAX-PAID.0" diagnostics="errorCode.PFI-TOTAL-FOREIGN-TAX-PAID.0 transactional.PFI-TOTAL-FOREIGN-TAX-PAID.0 transactional.en.PFI-TOTAL-FOREIGN-TAX-PAID.0 ">[2.8] is present. [2.6] or [2.6A] or [2.7] should also be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p69">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipForeign/ptr:ForeignIncomeSavingsLandProperty/ptr:ForeignLettingsLoss">
        <sch:assert test="../../ptr:IncomeLandPropertyAbroad/ptr:AllowableLoss or ../../ptr:IncomeLandPropertyAbroad/ptr:TotalAllowableLoss" id="a_PFI-FOREIGN-LET-PROPERTY-LOSS.0" diagnostics="errorCode.PFI-FOREIGN-LET-PROPERTY-LOSS.0 transactional.PFI-FOREIGN-LET-PROPERTY-LOSS.0 transactional.en.PFI-FOREIGN-LET-PROPERTY-LOSS.0 ">If [2.10] is present, [2.29] or [2.34] should be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p70">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipForeign/ptr:ForeignIncomeSavingsLandProperty/ptr:ResidentialFinanceCosts">
        <sch:assert test="(../../ptr:IncomeLandPropertyAbroad/ptr:ResidentialFinanceCosts or ../../ptr:IncomeLandPropertyAbroad/ptr:TotalAmountFinanceCosts)" id="a_PFI-RES-FIN-COSTS.0" diagnostics="errorCode.PFI-RES-FIN-COSTS.0 transactional.PFI-RES-FIN-COSTS.0 transactional.en.PFI-RES-FIN-COSTS.0 ">If [2.10A] is present, [2.30A] or [2.33A] must be present</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p62">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipForeign/ptr:ForeignIncomeSavingsLandProperty">
        <sch:assert test="ptr:ReturnPeriodStart or not(ptr:TotalIncomeRemittable or ptr:TotalDividendsIncomeRemittable or ptr:TotalGross or ptr:TotalForeignTax or ptr:DisposalsOfOffshoreFunds or ptr:ForeignLettingsLoss)" id="a_RIM-PFI-FGN-INC-SAVINGS-LAND-PPTY.0" diagnostics="errorCode.RIM-PFI-FGN-INC-SAVINGS-LAND-PPTY.0 transactional.RIM-PFI-FGN-INC-SAVINGS-LAND-PPTY.0 transactional.en.RIM-PFI-FGN-INC-SAVINGS-LAND-PPTY.0 ">If any of the following are present - [2.6], [2.6A], [2.7], [2.8], [2.9], [2.10] then [2.4] must be present</sch:assert>
        <sch:assert test="not ( ptr:InterestEtc/ptr:InterestEtcRow/ptr:Gross[not (../ptr:Unremittable = &apos;yes&apos;)]) 
              or 
            ptr:TotalIncomeRemittable" id="a_RIM-PFI-FGN-INC-SAVINGS-LAND-PPTY.1" diagnostics="errorCode.RIM-PFI-FGN-INC-SAVINGS-LAND-PPTY.1 transactional.RIM-PFI-FGN-INC-SAVINGS-LAND-PPTY.1 transactional.en.RIM-PFI-FGN-INC-SAVINGS-LAND-PPTY.1 ">[2.6] is mandatory if any entries with no corresponding tick in "Unremittable tickbox of [2.2.1 Country/2.2.2 Unremittable/2.2.3 Gross/2.2.4 Foreign Tax -]" are present in [2.2.1 Country/2.2.2 Unremittable/2.2.3 Gross/2.2.4 Foreign Tax -]</sch:assert>
        <sch:assert test="not(ptr:Dividends/ptr:DividendsRow/ptr:Gross[not (../ptr:Unremittable = &apos;yes&apos;)])
              or
            ptr:TotalDividendsIncomeRemittable" id="a_RIM-PFI-FGN-INC-SAVINGS-LAND-PPTY.2" diagnostics="errorCode.RIM-PFI-FGN-INC-SAVINGS-LAND-PPTY.2 transactional.RIM-PFI-FGN-INC-SAVINGS-LAND-PPTY.2 transactional.en.RIM-PFI-FGN-INC-SAVINGS-LAND-PPTY.2 ">[2.6A] is mandatory if any entries with no corresponding tick in "Unremittable tickbox of [2.2A.1 Country/2.2A.2 Unremittable/2.2A.3 Gross/2.2A.4 Foreign Tax -]" are present in [2.2A.1 Country/2.2A.2 Unremittable/2.2A.3 Gross/2.2A.4 Foreign Tax -]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p73">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipForeign/ptr:IncomeLandPropertyAbroad/ptr:IncomeLandAndPropertyAbroad/ptr:Expenses/ptr:TotalExpenditure">
        <sch:assert test="(math:abs((.) - ((sum(../ptr:RentRatesEtc) + sum(../ptr:RepairsAndRenewals) + sum(../ptr:FinanceCharges) + sum(../ptr:LegalAndProfessionalCosts) + sum(../ptr:CostOfServices) + sum(../ptr:OtherExpenses)))) &lt; 0.001)" id="a_RIM-PFI-TOTAL-EXPENDITURE.0" diagnostics="errorCode.RIM-PFI-TOTAL-EXPENDITURE.0 transactional.RIM-PFI-TOTAL-EXPENDITURE.0 transactional.en.RIM-PFI-TOTAL-EXPENDITURE.0 ">[2.18] should equal ( The sum of [2.12], [2.13], [2.14], [2.15], [2.16], and [2.17] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p72">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipForeign/ptr:IncomeLandPropertyAbroad/ptr:IncomeLandAndPropertyAbroad/ptr:Expenses">
        <sch:assert test="not(ptr:RentRatesEtc or ptr:RepairsAndRenewals or ptr:FinanceCharges or ptr:LegalAndProfessionalCosts or ptr:CostOfServices or ptr:OtherExpenses) or ptr:TotalExpenditure" id="a_RIM-PFI-TOTAL-EXPENDITURE.global.21" diagnostics="errorCode.RIM-PFI-TOTAL-EXPENDITURE.global.21 transactional.RIM-PFI-TOTAL-EXPENDITURE.global.21 transactional.en.RIM-PFI-TOTAL-EXPENDITURE.global.21 ">[2.18] should be present if [2.12] or [2.13] or [2.14] or [2.15] or [2.16] or [2.17]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p74">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipForeign/ptr:IncomeLandPropertyAbroad/ptr:IncomeLandAndPropertyAbroad/ptr:NetProfitLoss">
        <sch:assert test="(math:abs((.) - ((sum(../ptr:TotalRentsEtc) - sum(../ptr:Expenses/ptr:TotalExpenditure)))) &lt; 0.001)" id="a_RIM-PFI-NET-PROFIT-LOSS.0" diagnostics="errorCode.RIM-PFI-NET-PROFIT-LOSS.0 transactional.RIM-PFI-NET-PROFIT-LOSS.0 transactional.en.RIM-PFI-NET-PROFIT-LOSS.0 ">[2.19] should equal ( [2.11] minus [2.18] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p76">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipForeign/ptr:IncomeLandPropertyAbroad/ptr:IncomeLandAndPropertyAbroad/ptr:TaxAdjustments/ptr:AdditionsToNetProfit/ptr:TotalAdditions">
        <sch:assert test="(math:abs((.) - ((sum(../ptr:PrivateUse) + sum(../ptr:BalancingCharges)))) &lt; 0.001)" id="a_RIM-PFI-TOTAL-ADDITIONS.0" diagnostics="errorCode.RIM-PFI-TOTAL-ADDITIONS.0 transactional.RIM-PFI-TOTAL-ADDITIONS.0 transactional.en.RIM-PFI-TOTAL-ADDITIONS.0 ">[2.22] should equal ( [2.20] plus [2.21] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p75">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipForeign/ptr:IncomeLandPropertyAbroad/ptr:IncomeLandAndPropertyAbroad/ptr:TaxAdjustments/ptr:AdditionsToNetProfit">
        <sch:assert test="not(ptr:PrivateUse or ptr:BalancingCharges) or ptr:TotalAdditions" id="a_RIM-PFI-TOTAL-ADDITIONS.global.23" diagnostics="errorCode.RIM-PFI-TOTAL-ADDITIONS.global.23 transactional.RIM-PFI-TOTAL-ADDITIONS.global.23 transactional.en.RIM-PFI-TOTAL-ADDITIONS.global.23 ">[2.22] should be present if [2.20] or [2.21]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p78">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipForeign/ptr:IncomeLandPropertyAbroad/ptr:IncomeLandAndPropertyAbroad/ptr:TaxAdjustments/ptr:DeductionsFromNetProfit/ptr:TotalDeductions">
        <sch:assert test="(math:abs((.) - ((sum(../ptr:ElectricChargePointAllowance) + sum(../ptr:TheStructuresAndBuildingsAllowance) + sum(../ptr:ZeroEmissionCarAllowance) + sum(../ptr:CapitalAllowances) + sum(../ptr:CostsOfReplacingDomesticItems)))) &lt; 0.001)" id="a_RIM-PFI-TOTAL-DEDUCTIONS.0" diagnostics="errorCode.RIM-PFI-TOTAL-DEDUCTIONS.0 transactional.RIM-PFI-TOTAL-DEDUCTIONS.0 transactional.en.RIM-PFI-TOTAL-DEDUCTIONS.0 ">[2.25] is valid only if this equals ( The sum of [2.21A], [2.21B], [2.21C], [2.23], and [2.24] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p77">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipForeign/ptr:IncomeLandPropertyAbroad/ptr:IncomeLandAndPropertyAbroad/ptr:TaxAdjustments/ptr:DeductionsFromNetProfit">
        <sch:assert test="not(ptr:ElectricChargePointAllowance or ptr:TheStructuresAndBuildingsAllowance or ptr:ZeroEmissionCarAllowance or ptr:CapitalAllowances or ptr:CostsOfReplacingDomesticItems)
                  or ptr:TotalDeductions" id="a_RIM-PFI-TOTAL-DEDUCTIONS.global.24" diagnostics="errorCode.RIM-PFI-TOTAL-DEDUCTIONS.global.24 transactional.RIM-PFI-TOTAL-DEDUCTIONS.global.24 transactional.en.RIM-PFI-TOTAL-DEDUCTIONS.global.24 ">[2.25] should be present if any of [2.21A], [2.21B], [2.21C], [2.23] or [2.24] are present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p79">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipForeign/ptr:IncomeLandPropertyAbroad/ptr:IncomeLandAndPropertyAbroad/ptr:AdjustedProfit">
        <sch:assert test="(
  ((sum(../ptr:NetProfitLoss) + sum(../ptr:TaxAdjustments/ptr:AdditionsToNetProfit/ptr:TotalAdditions) - sum(../ptr:TaxAdjustments/ptr:DeductionsFromNetProfit/ptr:TotalDeductions)) - (0) &gt;= 0.001) and (math:abs((.) - (sum(../ptr:NetProfitLoss) + sum(../ptr:TaxAdjustments/ptr:AdditionsToNetProfit/ptr:TotalAdditions) - sum(../ptr:TaxAdjustments/ptr:DeductionsFromNetProfit/ptr:TotalDeductions))) &lt; 0.001)
)
or
(
  ((sum(../ptr:NetProfitLoss) + sum(../ptr:TaxAdjustments/ptr:AdditionsToNetProfit/ptr:TotalAdditions) - sum(../ptr:TaxAdjustments/ptr:DeductionsFromNetProfit/ptr:TotalDeductions)) - (0) &lt; 0.001) and (. = 0)
)" id="a_RIM-PFI-ADJUSTED-PROFIT.0" diagnostics="errorCode.RIM-PFI-ADJUSTED-PROFIT.0 transactional.RIM-PFI-ADJUSTED-PROFIT.0 transactional.en.RIM-PFI-ADJUSTED-PROFIT.0 ">If the sum [2.19] + [2.22] - [2.25]  is positive, [2.26] must equal the sum otherwise [2.26] must be zero or absent</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p80">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipForeign/ptr:IncomeLandPropertyAbroad/ptr:IncomeLandAndPropertyAbroad/ptr:AdjustedLoss">
        <sch:assert test="(
  ((sum(../ptr:TaxAdjustments/ptr:DeductionsFromNetProfit/ptr:TotalDeductions) - ( sum(../ptr:NetProfitLoss) + sum(../ptr:TaxAdjustments/ptr:AdditionsToNetProfit/ptr:TotalAdditions) )) - (0) &gt;= 0.001) and (math:abs((.) - (sum(../ptr:TaxAdjustments/ptr:DeductionsFromNetProfit/ptr:TotalDeductions) - ( sum(../ptr:NetProfitLoss) + sum(../ptr:TaxAdjustments/ptr:AdditionsToNetProfit/ptr:TotalAdditions) ))) &lt; 0.001)
)
or
(
  ((sum(../ptr:TaxAdjustments/ptr:DeductionsFromNetProfit/ptr:TotalDeductions) - ( sum(../ptr:NetProfitLoss) + sum(../ptr:TaxAdjustments/ptr:AdditionsToNetProfit/ptr:TotalAdditions) )) - (0) &lt; 0.001) and (. = 0)
)" id="a_RIM-PFI-ADJUSTED-LOSS.0" diagnostics="errorCode.RIM-PFI-ADJUSTED-LOSS.0 transactional.RIM-PFI-ADJUSTED-LOSS.0 transactional.en.RIM-PFI-ADJUSTED-LOSS.0 ">if the sum [2.19] + [2.22] - [2.25] is negative, [2.27] must equal the positive equivalent of the sum otherwise [2.27] must be zero or absent</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p71">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipForeign/ptr:IncomeLandPropertyAbroad/ptr:IncomeLandAndPropertyAbroad">
        <sch:assert test="not(ptr:TotalRentsEtc or ptr:Expenses/ptr:TotalExpenditure) or ptr:NetProfitLoss" id="a_RIM-PFI-NET-PROFIT-LOSS.global.22" diagnostics="errorCode.RIM-PFI-NET-PROFIT-LOSS.global.22 transactional.RIM-PFI-NET-PROFIT-LOSS.global.22 transactional.en.RIM-PFI-NET-PROFIT-LOSS.global.22 ">[2.19] should be present if [2.11] or [2.18]</sch:assert>
        <sch:assert test="not(((((sum(ptr:NetProfitLoss) + sum(ptr:TaxAdjustments/ptr:AdditionsToNetProfit/ptr:TotalAdditions)) - sum(ptr:TaxAdjustments/ptr:DeductionsFromNetProfit/ptr:TotalDeductions))) - (0) &gt;= 0.001)) or ptr:AdjustedProfit" id="a_RIM-PFI-ADJUSTED-PROFIT.global.25" diagnostics="errorCode.RIM-PFI-ADJUSTED-PROFIT.global.25 transactional.RIM-PFI-ADJUSTED-PROFIT.global.25 transactional.en.RIM-PFI-ADJUSTED-PROFIT.global.25 ">[2.26] should be present if ( ( [2.19] plus [2.22] ) minus [2.25] ) exceeds 0</sch:assert>
        <sch:assert test="not(((((sum(ptr:NetProfitLoss) + sum(ptr:TaxAdjustments/ptr:AdditionsToNetProfit/ptr:TotalAdditions)) - sum(ptr:TaxAdjustments/ptr:DeductionsFromNetProfit/ptr:TotalDeductions))) - (0) &lt;= -0.001)) or ptr:AdjustedLoss" id="a_RIM-PFI-ADJUSTED-LOSS.global.26" diagnostics="errorCode.RIM-PFI-ADJUSTED-LOSS.global.26 transactional.RIM-PFI-ADJUSTED-LOSS.global.26 transactional.en.RIM-PFI-ADJUSTED-LOSS.global.26 ">[2.27] should be present if ( ( [2.19] plus [2.22] ) minus [2.25] ) is less than 0</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p81">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipForeign/ptr:IncomeLandPropertyAbroad/ptr:MultipleLettings">
        <sch:assert test="not(((sum(ptr:MultipleLetting/ptr:TaxableProfitOrLoss)) - (0) &gt;= 0.001)) or ((math:abs((sum(../ptr:TotalTaxableProfit)) - (sum(ptr:MultipleLetting/ptr:TaxableProfitOrLoss))) &lt; 0.001))" id="a_id16.0" diagnostics="errorCode.id16.0 transactional.id16.0 transactional.en.id16.0 ">[2.31] must be present and equal to the total of all iterations of [2.4.2] if total is positive.</sch:assert>
        <sch:assert test="not(((sum(ptr:MultipleLetting/ptr:TaxableProfitOrLoss)) - (0) &lt;= -0.001)) or ((math:abs((sum(../ptr:TotalAllowableLoss)) - (math:abs(sum(ptr:MultipleLetting/ptr:TaxableProfitOrLoss)))) &lt; 0.001))" id="a_id16.1" diagnostics="errorCode.id16.1 transactional.id16.1 transactional.en.id16.1 ">[2.34] must be present and equal to the absolute value of the total of all iterations of [2.4.2] if total is negative.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p82">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipForeign/ptr:IncomeLandPropertyAbroad/ptr:TotalForeignTax">
        <sch:assert test="(math:abs((.) - (sum(../ptr:MultipleLettings/ptr:MultipleLetting/ptr:ForeignTax))) &lt; 0.001)" id="a_RIM-PFI-TOTAL-FOREIGN-TAX.1" diagnostics="errorCode.RIM-PFI-TOTAL-FOREIGN-TAX.1 transactional.RIM-PFI-TOTAL-FOREIGN-TAX.1 transactional.en.RIM-PFI-TOTAL-FOREIGN-TAX.1 ">eq total of all iterations of [2.4.3]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p83">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipForeign/ptr:IncomeLandPropertyAbroad/ptr:TotalAmountChargeable">
        <sch:assert test="(math:abs((.) - (sum(../ptr:MultipleLettings/ptr:MultipleLetting/ptr:AmountChargeable))) &lt; 0.001)" id="a_RIM-PFI-TOTAL-AMT-CHRGBL.1" diagnostics="errorCode.RIM-PFI-TOTAL-AMT-CHRGBL.1 transactional.RIM-PFI-TOTAL-AMT-CHRGBL.1 transactional.en.RIM-PFI-TOTAL-AMT-CHRGBL.1 ">eq total of all iterations of [2.4.4]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p84">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipForeign/ptr:IncomeLandPropertyAbroad/ptr:TotalAmountFinanceCosts">
        <sch:assert test="(math:abs((.) - (sum(../ptr:MultipleLettings/ptr:MultipleLetting/ptr:ResidentialFinanceCosts))) &lt; 0.001)" id="a_RIM-PFI-TOTAL-RES-FIN-COSTS.0" diagnostics="errorCode.RIM-PFI-TOTAL-RES-FIN-COSTS.0 transactional.RIM-PFI-TOTAL-RES-FIN-COSTS.0 transactional.en.RIM-PFI-TOTAL-RES-FIN-COSTS.0 ">[2.33A] must be equal to the total of all iterations of [2.4.5].</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p61">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipForeign">
        <sch:assert test="not ( ../ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:AccountingPeriodStart )
          or
          (round(date:seconds(normalize-space(../ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:AccountingPeriodStart)) div 86400) = round(date:seconds(normalize-space(ptr:ForeignIncomeSavingsLandProperty/ptr:ReturnPeriodStart)) div 86400))" id="a_PFI-FOREIGN-PERIOD-START-DATE.0" diagnostics="errorCode.PFI-FOREIGN-PERIOD-START-DATE.0 transactional.PFI-FOREIGN-PERIOD-START-DATE.0 transactional.en.PFI-FOREIGN-PERIOD-START-DATE.0 ">If [3.4] present then [2.4] must equal [3.4]</sch:assert>
        <sch:assert test="not ( ../ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:AccountingPeriodEnd )
          or
          (round(date:seconds(normalize-space(../ptr:Partnership/ptr:TradingAndProfessionalIncomes/ptr:Income/ptr:AccountingPeriodEnd)) div 86400) = round(date:seconds(normalize-space(ptr:ForeignIncomeSavingsLandProperty/ptr:ReturnPeriodEnd)) div 86400))" id="a_PFI-FOREIGN-PERIOD-START-DATE.1" diagnostics="errorCode.PFI-FOREIGN-PERIOD-START-DATE.1 transactional.PFI-FOREIGN-PERIOD-START-DATE.1 transactional.en.PFI-FOREIGN-PERIOD-START-DATE.1 ">If [3.5] present then [2.5] must equal [3.5]</sch:assert>
        <sch:assert test="not(ptr:ForeignIncomeSavingsLandProperty/ptr:ChargeablePremiums/ptr:Gross) or ptr:ForeignIncomeSavingsLandProperty/ptr:TotalGross" id="a_PFI-OTHER-UNTAXED-FOREIGN-INC.global.20" diagnostics="errorCode.PFI-OTHER-UNTAXED-FOREIGN-INC.global.20 transactional.PFI-OTHER-UNTAXED-FOREIGN-INC.global.20 transactional.en.PFI-OTHER-UNTAXED-FOREIGN-INC.global.20 ">[2.7] should be present if [2.3A.3]</sch:assert>
        <sch:assert test="not(ptr:IncomeLandPropertyAbroad/ptr:MultipleLettings/ptr:MultipleLetting/ptr:ForeignTax) or ptr:IncomeLandPropertyAbroad/ptr:TotalForeignTax" id="a_RIM-PFI-TOTAL-FOREIGN-TAX.global.27" diagnostics="errorCode.RIM-PFI-TOTAL-FOREIGN-TAX.global.27 transactional.RIM-PFI-TOTAL-FOREIGN-TAX.global.27 transactional.en.RIM-PFI-TOTAL-FOREIGN-TAX.global.27 ">[2.32] should be present if [2.4.3]</sch:assert>
        <sch:assert test="not(ptr:IncomeLandPropertyAbroad/ptr:MultipleLettings/ptr:MultipleLetting/ptr:AmountChargeable) or ptr:IncomeLandPropertyAbroad/ptr:TotalAmountChargeable" id="a_RIM-PFI-TOTAL-AMT-CHRGBL.global.28" diagnostics="errorCode.RIM-PFI-TOTAL-AMT-CHRGBL.global.28 transactional.RIM-PFI-TOTAL-AMT-CHRGBL.global.28 transactional.en.RIM-PFI-TOTAL-AMT-CHRGBL.global.28 ">[2.33] should be present if [2.4.4]</sch:assert>
        <sch:assert test="ptr:ForeignIncomeSavingsLandProperty/ptr:TraditionalAccounting or ((((sum(ptr:IncomeLandPropertyAbroad/ptr:IncomeLandAndPropertyAbroad/ptr:TotalRentsEtc) + sum(ptr:IncomeLandPropertyAbroad/ptr:IncomeLandAndPropertyAbroad/ptr:TaxAdjustments/ptr:AdditionsToNetProfit/ptr:BalancingCharges))) - (150000) &lt; 0.001))" id="a_SA802.0" diagnostics="errorCode.SA802.0 transactional.SA802.0 transactional.en.SA802.0 ">If [2.8A] is absent then the sum of all instances of ( [2.11] + [2.21] ) must not exceed [£150,000]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p86">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipChargeableAssets/ptr:TotalProceeds">
        <sch:assert test="(math:abs((.) - (sum(../ptr:Disposals/ptr:DisposalRow/ptr:Proceeds))) &lt; 0.001)" id="a_PDA-TOT-DISPOSAL-CHRGBLE-ASSET.0" diagnostics="errorCode.PDA-TOT-DISPOSAL-CHRGBLE-ASSET.0 transactional.PDA-TOT-DISPOSAL-CHRGBLE-ASSET.0 transactional.en.PDA-TOT-DISPOSAL-CHRGBLE-ASSET.0 ">[4.1] must eq total of [4.1.3]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p85">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipChargeableAssets">
        <sch:assert test="not(ptr:Disposals/ptr:DisposalRow/ptr:Proceeds) or ptr:TotalProceeds" id="a_PDA-TOT-DISPOSAL-CHRGBLE-ASSET.global.29" diagnostics="errorCode.PDA-TOT-DISPOSAL-CHRGBLE-ASSET.global.29 transactional.PDA-TOT-DISPOSAL-CHRGBLE-ASSET.global.29 transactional.en.PDA-TOT-DISPOSAL-CHRGBLE-ASSET.global.29 ">[4.1] should be present if [4.1.3]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p88">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipSavings/ptr:Interest/ptr:TaxNotDeducted/ptr:PeriodEnd">
        <sch:assert test="not(../ptr:PeriodStart)
                  or
                not((.))
                  or
                (round(date:seconds(normalize-space(../ptr:PeriodStart)) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))" id="a_PSI-INTEREST-PERIOD-END-DATE.0" diagnostics="errorCode.PSI-INTEREST-PERIOD-END-DATE.0 transactional.PSI-INTEREST-PERIOD-END-DATE.0 transactional.en.PSI-INTEREST-PERIOD-END-DATE.0 ">[7.2] should be after [7.1]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p89">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipSavings/ptr:Interest/ptr:TaxNotDeducted/ptr:TotalInterestTaxNotDeducted">
        <sch:assert test="../ptr:PeriodStart" id="a_PSI-TOTAL-UNTAXED-INTEREST.0" diagnostics="errorCode.PSI-TOTAL-UNTAXED-INTEREST.0 transactional.PSI-TOTAL-UNTAXED-INTEREST.0 transactional.en.PSI-TOTAL-UNTAXED-INTEREST.0 ">If [7.6] is present, [7.1] should be present</sch:assert>
        <sch:assert test="(math:abs((.) - ((sum(../ptr:UntaxedUKinterest) + sum(../ptr:NationalSavings) + sum(../ptr:OtherIncomeFromUKsavings)))) &lt; 0.001)" id="a_PSI-TOTAL-UNTAXED-INTEREST.1" diagnostics="errorCode.PSI-TOTAL-UNTAXED-INTEREST.1 transactional.PSI-TOTAL-UNTAXED-INTEREST.1 transactional.en.PSI-TOTAL-UNTAXED-INTEREST.1 ">[7.6] should equal the sum of [7.3], [7.4], and [7.5].</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p90">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipSavings/ptr:Interest/ptr:TaxDeducted/ptr:UKinterestPaid/ptr:Tax">
        <sch:assert test="math:abs(. - sum(../ptr:Gross) * 0.2) &lt;= 1.001" id="a_SavingsBasicRateTax.0" diagnostics="errorCode.SavingsBasicRateTax.0 transactional.SavingsBasicRateTax.0 transactional.en.SavingsBasicRateTax.0 ">Tax must equal Gross * Lower savings rate [20%]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p91">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipSavings/ptr:Interest/ptr:TaxDeducted/ptr:UKinterestPaid/ptr:Gross">
        <sch:assert test="math:abs(. - (sum(../ptr:Net) + sum(../ptr:Tax))) &lt;= 1.001" id="a_SavingsBasicRateGross.0" diagnostics="errorCode.SavingsBasicRateGross.0 transactional.SavingsBasicRateGross.0 transactional.en.SavingsBasicRateGross.0 ">Gross must equal Net + Tax</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p92">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipSavings/ptr:Interest/ptr:TaxDeducted/ptr:OtherIncome/ptr:Tax">
        <sch:assert test="math:abs(. - sum(../ptr:Gross) * 0.2) &lt;= 1.001" id="a_SavingsBasicRateTax.0.0" diagnostics="errorCode.SavingsBasicRateTax.0.0 transactional.SavingsBasicRateTax.0.0 transactional.en.SavingsBasicRateTax.0.0 ">Tax must equal Gross * Lower savings rate [20%]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p93">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipSavings/ptr:Interest/ptr:TaxDeducted/ptr:OtherIncome/ptr:Gross">
        <sch:assert test="math:abs(. - (sum(../ptr:Net) + sum(../ptr:Tax))) &lt;= 1.001" id="a_SavingsBasicRateGross.0.0" diagnostics="errorCode.SavingsBasicRateGross.0.0 transactional.SavingsBasicRateGross.0.0 transactional.en.SavingsBasicRateGross.0.0 ">Gross must equal Net + Tax</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p94">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipSavings/ptr:Interest/ptr:TaxDeducted/ptr:TotalTaxDeducted">
        <sch:assert test="(math:abs((.) - (sum(../ptr:UKinterestPaid/ptr:Tax) + sum(../ptr:OtherIncome/ptr:Tax))) &lt; 0.001)" id="a_PSI-TOTAL-INT-TAX-DEDUCTED.0" diagnostics="errorCode.PSI-TOTAL-INT-TAX-DEDUCTED.0 transactional.PSI-TOTAL-INT-TAX-DEDUCTED.0 transactional.en.PSI-TOTAL-INT-TAX-DEDUCTED.0 ">[7.17] should equal [7.8] + [7.15].</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p95">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipSavings/ptr:Interest/ptr:TaxDeducted/ptr:TotalGross">
        <sch:assert test="(math:abs((.) - (sum(../ptr:UKinterestPaid/ptr:Gross) + sum(../ptr:OtherIncome/ptr:Gross))) &lt; 0.001)" id="a_PSI-TOTAL-INT-BEFORE-TAX-DED.0" diagnostics="errorCode.PSI-TOTAL-INT-BEFORE-TAX-DED.0 transactional.PSI-TOTAL-INT-BEFORE-TAX-DED.0 transactional.en.PSI-TOTAL-INT-BEFORE-TAX-DED.0 ">[7.18] should equal [7.9] + [7.16].</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p96">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipSavings/ptr:Dividends/ptr:TotalDividends">
        <sch:assert test="(math:abs((.) - ((sum(../ptr:UKcompanies) + sum(../ptr:UKauthorisedUnitTrusts) + sum(../ptr:StockDividends) + sum(../ptr:BonusIssuesOfSecuritiesAndRedeemableShares)))) &lt; 0.001)" id="a_PSI3-TOTAL-TAXED-SAVINGS.0" diagnostics="errorCode.PSI3-TOTAL-TAXED-SAVINGS.0 transactional.PSI3-TOTAL-TAXED-SAVINGS.0 transactional.en.PSI3-TOTAL-TAXED-SAVINGS.0 ">[7.23] should equal ( The sum of [7.19], [7.20], [7.21], and [7.22] )</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p97">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipSavings/ptr:OtherIncome/ptr:WithoutTaxDeducted/ptr:PeriodEnd">
        <sch:assert test="not(../ptr:PeriodStart)
                  or
                not((.))
                  or
                (round(date:seconds(normalize-space(../ptr:PeriodStart)) div 86400) &lt;= round(date:seconds(normalize-space((.))) div 86400))" id="a_PSI-OTHER-PERIOD-END-DATE.0" diagnostics="errorCode.PSI-OTHER-PERIOD-END-DATE.0 transactional.PSI-OTHER-PERIOD-END-DATE.0 transactional.en.PSI-OTHER-PERIOD-END-DATE.0 ">[7.25] should be after [7.24]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p98">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipSavings/ptr:OtherIncome/ptr:WithoutTaxDeducted/ptr:Profit">
        <sch:assert test="../ptr:PeriodStart" id="a_PSI-OTHER-UNTAXED-UK-INCOME.0" diagnostics="errorCode.PSI-OTHER-UNTAXED-UK-INCOME.0 transactional.PSI-OTHER-UNTAXED-UK-INCOME.0 transactional.en.PSI-OTHER-UNTAXED-UK-INCOME.0 ">[7.26] is present, so [7.24] should be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p99">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipSavings/ptr:OtherIncome/ptr:WithoutTaxDeducted/ptr:Loss">
        <sch:assert test="../ptr:PeriodStart" id="a_PSI-OTHER-UNTAXED-UK-INC-LOSS.0" diagnostics="errorCode.PSI-OTHER-UNTAXED-UK-INC-LOSS.0 transactional.PSI-OTHER-UNTAXED-UK-INC-LOSS.0 transactional.en.PSI-OTHER-UNTAXED-UK-INC-LOSS.0 ">[7.27] is present, so [7.24] should be present.</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p100">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipSavings/ptr:OtherIncome/ptr:WithTaxDeducted/ptr:Tax">
        <sch:assert test="math:abs(. - sum(../ptr:Gross) * 0.2) &lt;= 1.001" id="a_SavingsBasicRateTax.0.1" diagnostics="errorCode.SavingsBasicRateTax.0.1 transactional.SavingsBasicRateTax.0.1 transactional.en.SavingsBasicRateTax.0.1 ">Tax must equal Gross * Lower savings rate [20%]</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p101">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipSavings/ptr:OtherIncome/ptr:WithTaxDeducted/ptr:Gross">
        <sch:assert test="math:abs(. - (sum(../ptr:Net) + sum(../ptr:Tax))) &lt;= 1.001" id="a_SavingsBasicRateGross.0.1" diagnostics="errorCode.SavingsBasicRateGross.0.1 transactional.SavingsBasicRateGross.0.1 transactional.en.SavingsBasicRateGross.0.1 ">Gross must equal Net + Tax</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p87">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:PartnershipSavings">
        <sch:assert test="not(ptr:Interest/ptr:TaxNotDeducted/ptr:UntaxedUKinterest or ptr:Interest/ptr:TaxNotDeducted/ptr:NationalSavings or ptr:Interest/ptr:TaxNotDeducted/ptr:OtherIncomeFromUKsavings) or ptr:Interest/ptr:TaxNotDeducted/ptr:TotalInterestTaxNotDeducted" id="a_PSI-TOTAL-UNTAXED-INTEREST.global.30" diagnostics="errorCode.PSI-TOTAL-UNTAXED-INTEREST.global.30 transactional.PSI-TOTAL-UNTAXED-INTEREST.global.30 transactional.en.PSI-TOTAL-UNTAXED-INTEREST.global.30 ">[7.6] should be present if [7.3] or [7.4] or [7.5]</sch:assert>
        <sch:assert test="not(ptr:Interest/ptr:TaxDeducted/ptr:UKinterestPaid/ptr:Tax or ptr:Interest/ptr:TaxDeducted/ptr:OtherIncome/ptr:Tax) or ptr:Interest/ptr:TaxDeducted/ptr:TotalTaxDeducted" id="a_PSI-TOTAL-INT-TAX-DEDUCTED.global.31" diagnostics="errorCode.PSI-TOTAL-INT-TAX-DEDUCTED.global.31 transactional.PSI-TOTAL-INT-TAX-DEDUCTED.global.31 transactional.en.PSI-TOTAL-INT-TAX-DEDUCTED.global.31 ">[7.17] should be present if [7.8] or [7.15].</sch:assert>
        <sch:assert test="not(ptr:Interest/ptr:TaxDeducted/ptr:UKinterestPaid/ptr:Gross or ptr:Interest/ptr:TaxDeducted/ptr:OtherIncome/ptr:Gross) or ptr:Interest/ptr:TaxDeducted/ptr:TotalGross" id="a_PSI-TOTAL-INT-BEFORE-TAX-DED.global.32" diagnostics="errorCode.PSI-TOTAL-INT-BEFORE-TAX-DED.global.32 transactional.PSI-TOTAL-INT-BEFORE-TAX-DED.global.32 transactional.en.PSI-TOTAL-INT-BEFORE-TAX-DED.global.32 ">[7.18] should be present if [7.9] or [7.16].</sch:assert>
        <sch:assert test="not(ptr:Dividends/ptr:UKcompanies or ptr:Dividends/ptr:UKauthorisedUnitTrusts or ptr:Dividends/ptr:StockDividends or ptr:Dividends/ptr:BonusIssuesOfSecuritiesAndRedeemableShares) or ptr:Dividends/ptr:TotalDividends" id="a_PSI3-TOTAL-TAXED-SAVINGS.global.35" diagnostics="errorCode.PSI3-TOTAL-TAXED-SAVINGS.global.35 transactional.PSI3-TOTAL-TAXED-SAVINGS.global.35 transactional.en.PSI3-TOTAL-TAXED-SAVINGS.global.35 ">[7.23] should be present if [7.19] or [7.20] or [7.21] or [7.22].</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p102">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:AttachedFiles/ptr:Attachment">
        <sch:assert test="starts-with(translate(normalize-space(.), &apos; &apos;, &apos;&apos;), &apos;JVBERi0x&apos;)" id="a_PTR-ATTACHMENT.1" diagnostics="errorCode.PTR-ATTACHMENT.1 transactional.PTR-ATTACHMENT.1 transactional.en.PTR-ATTACHMENT.1 ">Attachment content must be a PDF file starting with the byte sequence "%PDF-1" (i.e. the Base 64 encoded content starts with "JVBERi0x").</sch:assert>
      </sch:rule>
    </sch:pattern>
    <sch:pattern id="p3">
      <sch:rule context="/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership">
        <sch:assert test="not(@AmendedReturn)
            or
              not(../../../hd:Header/hd:MessageDetails/hd:GatewayTimestamp)
            or
              (
                date:date(normalize-space(concat(../../../hd:Header/hd:MessageDetails/hd:GatewayTimestamp, &apos;Z&apos;))) != &apos;&apos;
              and
                date:seconds(normalize-space(concat(../../../hd:Header/hd:MessageDetails/hd:GatewayTimestamp, &apos;Z&apos;))) &lt; date:seconds(normalize-space(date:add(normalize-space(&apos;2027-01-31T00:00:00Z&apos;),normalize-space(&apos;P1Y1D&apos;))))
              )
            or
              (
                date:date(normalize-space(concat(../../../hd:Header/hd:MessageDetails/hd:GatewayTimestamp, &apos;Z&apos;))) = &apos;&apos;
              and
                date:seconds(normalize-space(../../../hd:Header/hd:MessageDetails/hd:GatewayTimestamp)) &lt; date:seconds(normalize-space(date:add(normalize-space(&apos;2027-01-31T00:00:00Z&apos;),normalize-space(&apos;P1Y1D&apos;))))
              )" id="a_PSHIP-AMENDED-RETURN-IND.0" diagnostics="errorCode.PSHIP-AMENDED-RETURN-IND.0 transactional.PSHIP-AMENDED-RETURN-IND.0 transactional.en.PSHIP-AMENDED-RETURN-IND.0 ">Date of receipt of amendment must be less than 12 months following statutory due date</sch:assert>
        <sch:assert test="contains(/hd:GovTalkMessage/hd:Header/hd:MessageDetails/hd:Class, &apos;-ATT&apos;) or not(/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:AttachedFiles)" id="a_PTR-ATTACHMENT-CLASS.1" diagnostics="errorCode.PTR-ATTACHMENT-CLASS.1 transactional.PTR-ATTACHMENT-CLASS.1 transactional.en.PTR-ATTACHMENT-CLASS.1 ">Submission must not contain any attachments if the message class indicates no attachments</sch:assert>
        <sch:assert test="not(contains(/hd:GovTalkMessage/hd:Header/hd:MessageDetails/hd:Class, &apos;-ATT&apos;)) or (/hd:GovTalkMessage/hd:Body/ptr:IRenvelope/ptr:SApartnership/ptr:AttachedFiles)" id="a_PTR-ATTACHMENT-CLASS.2" diagnostics="errorCode.PTR-ATTACHMENT-CLASS.2 transactional.PTR-ATTACHMENT-CLASS.2 transactional.en.PTR-ATTACHMENT-CLASS.2 ">Submission must contain at least one attachment if the message class indicates attachments</sch:assert>
      </sch:rule>
    </sch:pattern>
  <sch:diagnostics>
    <sch:diagnostic id="errorCode.header.r1015">5004</sch:diagnostic>
    <sch:diagnostic id="transactional.header.r1015">At least one key must exist in the IRheader</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.header.r1015">At least one key must exist in the IRheader</sch:diagnostic>
    <sch:diagnostic id="errorCode.header.r1014">5005</sch:diagnostic>
    <sch:diagnostic id="transactional.header.r1014">Keys in the GovTalkDetails do not match those in the IRheader.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.header.r1014">Keys in the GovTalkDetails do not match those in the IRheader.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSHIP-AMENDED-RETURN-IND.0">5090</sch:diagnostic>
    <sch:diagnostic id="transactional.PSHIP-AMENDED-RETURN-IND.0">You have indicated an amended submission but the amendment window has now closed for the year of assessment to which your submission relates.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSHIP-AMENDED-RETURN-IND.0">You have indicated an amended submission but the amendment window has now closed for the year of assessment to which your submission relates.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-ATTACHMENT-CLASS.1">6001</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-ATTACHMENT-CLASS.1">Submission must not contain any attachments if the message class indicates no attachments</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-ATTACHMENT-CLASS.1">Submission must not contain any attachments if the message class indicates no attachments</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-ATTACHMENT-CLASS.2">6015</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-ATTACHMENT-CLASS.2">Submission must contain at least one attachment if the message class indicates attachments</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-ATTACHMENT-CLASS.2">Submission must contain at least one attachment if the message class indicates attachments</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-BUSINESS-NET-PROFIT-LOSS.global.0">6952</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-BUSINESS-NET-PROFIT-LOSS.global.0">There is an entry in [3.24] or [3.25]. Please complete box [3.26].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-BUSINESS-NET-PROFIT-LOSS.global.0">There is an entry in [3.24] or [3.25]. Please complete box [3.26].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-GROSS-PROFIT-LOSS.global.1">6953</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-GROSS-PROFIT-LOSS.global.1">There is an entry in [3.29] or [3.46] or [3.47] or [3.48]. Please complete box [3.49].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-GROSS-PROFIT-LOSS.global.1">There is an entry in [3.29] or [3.46] or [3.47] or [3.48]. Please complete box [3.49].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-TOTAL-EXPENDITURE.global.2">6954</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-TOTAL-EXPENDITURE.global.2">There is an entry in [3.51] or [3.52] or [3.53] or [3.54] or [3.55] or [3.56] or [3.57] or [3.58] or [3.59] or [3.60] or [3.61] or [3.62] or [3.63]. Please complete box [3.64].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-TOTAL-EXPENDITURE.global.2">There is an entry in [3.51] or [3.52] or [3.53] or [3.54] or [3.55] or [3.56] or [3.57] or [3.58] or [3.59] or [3.60] or [3.61] or [3.62] or [3.63]. Please complete box [3.64].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP3-NET-PROFIT-LOSS.global.3">6955</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP3-NET-PROFIT-LOSS.global.3">There is an entry in [3.49] or [3.50] or [3.64]. Please complete box [3.65].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP3-NET-PROFIT-LOSS.global.3">There is an entry in [3.49] or [3.50] or [3.64]. Please complete box [3.65].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-DISALLOW-EXPENDITURE.global.4a">6956</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-DISALLOW-EXPENDITURE.global.4a">There is an entry in [3.38] or [3.39] or [3.40] or [3.41] or [3.42] or [3.43] or [3.44] or [3.45]. Please complete box [3.66].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-DISALLOW-EXPENDITURE.global.4a">There is an entry in [3.38] or [3.39] or [3.40] or [3.41] or [3.42] or [3.43] or [3.44] or [3.45]. Please complete box [3.66].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-DISALLOW-EXPENDITURE.global.4b">6957</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-DISALLOW-EXPENDITURE.global.4b">There is an entry in [3.30] or [3.31] or [3.32] or [3.33] or [3.34] or [3.35] or [3.36] or [3.37]. Please complete box [3.66].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-DISALLOW-EXPENDITURE.global.4b">There is an entry in [3.30] or [3.31] or [3.32] or [3.33] or [3.34] or [3.35] or [3.36] or [3.37]. Please complete box [3.66].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-ADDITIONS-TO-NET-PROFIT.global.5">6958</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-ADDITIONS-TO-NET-PROFIT.global.5">There is an entry in [3.66] or [3.67] or [3.68]. Please complete box [3.69].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-ADDITIONS-TO-NET-PROFIT.global.5">There is an entry in [3.66] or [3.67] or [3.68]. Please complete box [3.69].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-TOTAL-DEDUCTIONS.global.6">6959</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-TOTAL-DEDUCTIONS.global.6">There is an entry in [3.70] or [3.71]. Please complete box [3.72].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-TOTAL-DEDUCTIONS.global.6">There is an entry in [3.70] or [3.71]. Please complete box [3.72].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP4-NET-BUSINESS-PROFIT-LOSS.global.7">6960</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP4-NET-BUSINESS-PROFIT-LOSS.global.7">There is an entry in [3.65] or [3.69] or [3.72]. Please complete box [3.73].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP4-NET-BUSINESS-PROFIT-LOSS.global.7">There is an entry in [3.65] or [3.69] or [3.72]. Please complete box [3.73].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-NET-PROFIT-FOR-YEAR.global.8">6961</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-NET-PROFIT-FOR-YEAR.global.8">The amount in box ([3.26] exceeds 0) or ([3.73] exceeds 0). Please complete box [3.83].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-NET-PROFIT-FOR-YEAR.global.8">The amount in box ([3.26] exceeds 0) or ([3.73] exceeds 0). Please complete box [3.83].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTF-PTNR-EXPORT-NEITHER.0">6602</sch:diagnostic>
    <sch:diagnostic id="transactional.PTF-PTNR-EXPORT-NEITHER.0">[6.1N] must not be present if [6.1G] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTF-PTNR-EXPORT-NEITHER.0">[6.1N] must not be present if [6.1G] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTF-PTNR-EXPORT-NEITHER.1">6607</sch:diagnostic>
    <sch:diagnostic id="transactional.PTF-PTNR-EXPORT-NEITHER.1">[6.1N] must not be present if [6.1S] is present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTF-PTNR-EXPORT-NEITHER.1">[6.1N] must not be present if [6.1S] is present</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP4-NET-BUSINESS-PROFIT-LOSS.0">6962</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP4-NET-BUSINESS-PROFIT-LOSS.0">The amount in box [3.68] must equal the amount in box [3.23] if there is an entry in any of boxes ([3.29], [3.50], [3.73]). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP4-NET-BUSINESS-PROFIT-LOSS.0">The amount in box [3.68] must equal the amount in box [3.23] if there is an entry in any of boxes ([3.29], [3.50], [3.73]). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-ACCOUNT-START-DATE.0">6600</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-ACCOUNT-START-DATE.0">There is an entry in box [3.4]. Please complete box [3.2].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-ACCOUNT-START-DATE.0">There is an entry in box [3.4]. Please complete box [3.2].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-ACCOUNT-START-DATE.1">6661</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-ACCOUNT-START-DATE.1">There is an entry in box [3.4] and box [7.6]. The date in box [7.1] must equal the date in box [3.4]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-ACCOUNT-START-DATE.1">There is an entry in box [3.4] and box [7.6]. The date in box [7.1] must equal the date in box [3.4]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-ACCOUNT-START-DATE.2">6698</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-ACCOUNT-START-DATE.2">There is a date in box [3.4] and an entry in one or more of boxes [7.26] and [7.27]. The date in box [7.24] must equal the date in box [3.4]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-ACCOUNT-START-DATE.2">There is a date in box [3.4] and an entry in one or more of boxes [7.26] and [7.27]. The date in box [7.24] must equal the date in box [3.4]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-ACCOUNT-START-DATE.3">6699</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-ACCOUNT-START-DATE.3">The date in box [N1.1] must equal the date in box [3.4]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-ACCOUNT-START-DATE.3">The date in box [N1.1] must equal the date in box [3.4]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-ACCOUNT-END-DATE.0">6601</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-ACCOUNT-END-DATE.0">The date in box [3.5] cannot be earlier than the date in box [3.4]. Please amend the incorrect entry.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-ACCOUNT-END-DATE.0">The date in box [3.5] cannot be earlier than the date in box [3.4]. Please amend the incorrect entry.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-ACCOUNT-END-DATE.1">6900</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-ACCOUNT-END-DATE.1">There is an entry in box [3.5] and box [7.6]. The date in box [7.2] must equal the date in box [3.5]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-ACCOUNT-END-DATE.1">There is an entry in box [3.5] and box [7.6]. The date in box [7.2] must equal the date in box [3.5]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-ACCOUNT-END-DATE.2">6950</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-ACCOUNT-END-DATE.2">If both [3.5] and one or more of [7.26] and [7.27] are present then [7.25] must equal [3.5]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-ACCOUNT-END-DATE.2">If both [3.5] and one or more of [7.26] and [7.27] are present then [7.25] must equal [3.5]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-ACCOUNT-END-DATE.3">6901</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-ACCOUNT-END-DATE.3">The date in box [N1.2] must equal the date in box [3.5]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-ACCOUNT-END-DATE.3">The date in box [N1.2] must equal the date in box [3.5]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-COMMENCEMENT-QUES.0">8565</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-COMMENCEMENT-QUES.0">[3.7] must be present if [3.7Q] equals 'yes'</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-COMMENCEMENT-QUES.0">[3.7] must be present if [3.7Q] equals 'yes'</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-COMMENCEMENT-DATE.0">8237</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-COMMENCEMENT-DATE.0">Date of commencement entered in box 3.7 must be on or before the 5th April of the return year. Please check</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-COMMENCEMENT-DATE.0">Date of commencement entered in box 3.7 must be on or before the 5th April of the return year. Please check</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-COMMENCEMENT-DATE.1">8370</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-COMMENCEMENT-DATE.1">Date of commencement entered in box 3.7 must be on or after the 6th April of the return year. Please check</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-COMMENCEMENT-DATE.1">Date of commencement entered in box 3.7 must be on or after the 6th April of the return year. Please check</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-CESSATION-QUES.0">8566</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-CESSATION-QUES.0">[3.8] must be present if [3.8Q] equals 'yes'</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-CESSATION-QUES.0">[3.8] must be present if [3.8Q] equals 'yes'</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-CESSATION-DATE.0">6603</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-CESSATION-DATE.0">The date in box [3.8] cannot be earlier than the date in box [3.7]. Please amend the incorrect entry.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-CESSATION-DATE.0">The date in box [3.8] cannot be earlier than the date in box [3.7]. Please amend the incorrect entry.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-CESSATION-DATE.1">6604</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-CESSATION-DATE.1">The date in box [3.8] must be within the return year. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-CESSATION-DATE.1">The date in box [3.8] must be within the return year. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-ANNUAL-INV-ALLCE-AMT.0">6902</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-ANNUAL-INV-ALLCE-AMT.0">The amount in box [3.13A] exceeds [£1,500,000]. Please check. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-ANNUAL-INV-ALLCE-AMT.0">The amount in box [3.13A] exceeds [£1,500,000]. Please check. </sch:diagnostic>
    <sch:diagnostic id="errorCode.PTF-CAPITAL-ALLOWANCE-TOTAL.0">6605</sch:diagnostic>
    <sch:diagnostic id="transactional.PTF-CAPITAL-ALLOWANCE-TOTAL.0">The amount in box [3.22] must equal ( the sum of [3.13A], [3.14], [3.14A], [3.16], [3.16A], [3.18], [3.18A], [3.18B] and [3.20] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTF-CAPITAL-ALLOWANCE-TOTAL.0">The amount in box [3.22] must equal ( the sum of [3.13A], [3.14], [3.14A], [3.16], [3.16A], [3.18], [3.18A], [3.18B] and [3.20] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP4-TOTAL-BALANCING-CHARGES.0">6606</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP4-TOTAL-BALANCING-CHARGES.0">The amount in box [3.23] must equal ( the sum of [3.15A], [3.17], and [3.21] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP4-TOTAL-BALANCING-CHARGES.0">The amount in box [3.23] must equal ( the sum of [3.15A], [3.17], and [3.21] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP4-TURNOVER-AND-RECEIPTS.0">8200</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP4-TURNOVER-AND-RECEIPTS.0">([3.24] - [3.23]) multiplied by days in return year (365 or 366) divided by days in period which begins in [3.4] and ends in [3.5] must be less than [£90,000] or greater than [£15,000,000]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP4-TURNOVER-AND-RECEIPTS.0">([3.24] - [3.23]) multiplied by days in return year (365 or 366) divided by days in period which begins in [3.4] and ends in [3.5] must be less than [£90,000] or greater than [£15,000,000]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP4-TURNOVER-AND-RECEIPTS.1">6608</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP4-TURNOVER-AND-RECEIPTS.1">There is an amount in box [3.24]. Please complete box [3.4].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP4-TURNOVER-AND-RECEIPTS.1">There is an amount in box [3.24]. Please complete box [3.4].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP4-TURNOVER-AND-RECEIPTS.2">6963</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP4-TURNOVER-AND-RECEIPTS.2">There is an amount in box [3.24]. Please complete box [3.5].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP4-TURNOVER-AND-RECEIPTS.2">There is an amount in box [3.24]. Please complete box [3.5].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP4-TURNOVER-AND-RECEIPTS.3">8201</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP4-TURNOVER-AND-RECEIPTS.3">As the entry in box [3.24] is greater than [£15,000,000], then [RIM-PTR-ATTACHMENT] must be present. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP4-TURNOVER-AND-RECEIPTS.3">As the entry in box [3.24] is greater than [£15,000,000], then [RIM-PTR-ATTACHMENT] must be present. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-BUSINESS-NET-PROFIT-LOSS.0">6609</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-BUSINESS-NET-PROFIT-LOSS.0">The amount in box [3.26] must equal ( [3.24] minus [3.25] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-BUSINESS-NET-PROFIT-LOSS.0">The amount in box [3.26] must equal ( [3.24] minus [3.25] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-EXCLUDE-VAT.0">6610</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-EXCLUDE-VAT.0">Box [3.28] must be absent if there is an entry in box [3.27]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-EXCLUDE-VAT.0">Box [3.28] must be absent if there is an entry in box [3.27]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-BUSINESS-SALES-TURNOVER.0">6611</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-BUSINESS-SALES-TURNOVER.0">There is an amount in box [3.29]. Please complete box [3.4].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-BUSINESS-SALES-TURNOVER.0">There is an amount in box [3.29]. Please complete box [3.4].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-BUSINESS-SALES-TURNOVER.1">6612</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-BUSINESS-SALES-TURNOVER.1">There is an amount in box [3.29]. Boxes [3.24], [3.25] and [3.26] must be absent. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-BUSINESS-SALES-TURNOVER.1">There is an amount in box [3.29]. Boxes [3.24], [3.25] and [3.26] must be absent. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-GROSS-PROFIT-LOSS.0">6613</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-GROSS-PROFIT-LOSS.0">The amount in box [3.49] must equal ( [3.29] minus ( the sum of [3.46], [3.47], and [3.48] ) ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-GROSS-PROFIT-LOSS.0">The amount in box [3.49] must equal ( [3.29] minus ( the sum of [3.46], [3.47], and [3.48] ) ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-OTHER-INCOME-PROFITS.0">6614</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-OTHER-INCOME-PROFITS.0">box [3.50] is valid if not [3.24] and not [3.25] and not [3.26] and [3.4]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-OTHER-INCOME-PROFITS.0">box [3.50] is valid if not [3.24] and not [3.25] and not [3.26] and [3.4]</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-DEPRECIATION.0">6615</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-DEPRECIATION.0">There is an entry in box [3.62]. Please complete box [3.44].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-DEPRECIATION.0">There is an entry in box [3.62]. Please complete box [3.44].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-TOTAL-EXPENDITURE.0">6616</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-TOTAL-EXPENDITURE.0">The amount in box [3.64] must equal ( the sum of [3.51], [3.52], [3.53], [3.54], [3.55], [3.56], [3.57], [3.58], [3.59], [3.60], [3.61], [3.62], &amp; [3.63] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-TOTAL-EXPENDITURE.0">The amount in box [3.64] must equal ( the sum of [3.51], [3.52], [3.53], [3.54], [3.55], [3.56], [3.57], [3.58], [3.59], [3.60], [3.61], [3.62], &amp; [3.63] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP3-NET-PROFIT-LOSS.0">6617</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP3-NET-PROFIT-LOSS.0">The amount in box [3.65] must equal ( ( [3.49] plus [3.50] ) minus [3.64] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP3-NET-PROFIT-LOSS.0">The amount in box [3.65] must equal ( ( [3.49] plus [3.50] ) minus [3.64] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-DISALLOW-EXPENDITURE.0">6618</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-DISALLOW-EXPENDITURE.0">The amount in box [3.66] exceeds ( the sum of [3.64], [3.46], [3.47], and [3.48] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-DISALLOW-EXPENDITURE.0">The amount in box [3.66] exceeds ( the sum of [3.64], [3.46], [3.47], and [3.48] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-DISALLOW-EXPENDITURE.1">6619</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-DISALLOW-EXPENDITURE.1">The amount in box [3.66] must equal sum of ([3.30], [3.31], [3.32], [3.33], [3.34], [3.35], [3.36], [3.37], [3.38], [3.39], [3.40], [3.41], [3.42], [3.43], [3.44], [3.45]). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-DISALLOW-EXPENDITURE.1">The amount in box [3.66] must equal sum of ([3.30], [3.31], [3.32], [3.33], [3.34], [3.35], [3.36], [3.37], [3.38], [3.39], [3.40], [3.41], [3.42], [3.43], [3.44], [3.45]). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-ADDITIONS-TO-NET-PROFIT.0">6620</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-ADDITIONS-TO-NET-PROFIT.0">The amount in box [3.69] must equal ( the sum of [3.66], [3.67], and [3.68] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-ADDITIONS-TO-NET-PROFIT.0">The amount in box [3.69] must equal ( the sum of [3.66], [3.67], and [3.68] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP4-CAPITAL-ALLOWANCES.0">6621</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP4-CAPITAL-ALLOWANCES.0">box [3.70] is valid if it equals [3.22] or [3.24] present or [3.25] present or [3.26] present</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP4-CAPITAL-ALLOWANCES.0">box [3.70] is valid if it equals [3.22] or [3.24] present or [3.25] present or [3.26] present</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-TOTAL-DEDUCTIONS.0">6622</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-TOTAL-DEDUCTIONS.0">The amount in box [3.72] must equal ( [3.70] plus [3.71] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-TOTAL-DEDUCTIONS.0">The amount in box [3.72] must equal ( [3.70] plus [3.71] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP4-NET-BUSINESS-PROFIT-LOSS.1">6624</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP4-NET-BUSINESS-PROFIT-LOSS.1">The amount in box [3.73] must equal [3.65] + [3.69] - [3.72]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP4-NET-BUSINESS-PROFIT-LOSS.1">The amount in box [3.73] must equal [3.65] + [3.69] - [3.72]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP4-NET-BUSINESS-PROFIT-LOSS.2">6625</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP4-NET-BUSINESS-PROFIT-LOSS.2">There is an amount in box [3.73]. Please complete box [3.4].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP4-NET-BUSINESS-PROFIT-LOSS.2">There is an amount in box [3.73]. Please complete box [3.4].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP4-NET-BUSINESS-PROFIT-LOSS.3">6626</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP4-NET-BUSINESS-PROFIT-LOSS.3">There is an amount in box [3.73]. Boxes [3.24], [3.25], [3.26] must be absent. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP4-NET-BUSINESS-PROFIT-LOSS.3">There is an amount in box [3.73]. Boxes [3.24], [3.25], [3.26] must be absent. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-ESTIMATED-FIGURES-SIG.0">8202</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-ESTIMATED-FIGURES-SIG.0">box [3.93] is valid if [3.10] != 'no' or [3.93] != 'no', or alternatively if one of the following conditions is met: if [3.26] is present and negative, then [3.84] equals the positive equivalent of [3.26]; otherwise, if [3.26] is absent and [3.73] is negative then [3.84] equals the positive equivalent of [3.73]
</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-ESTIMATED-FIGURES-SIG.0">box [3.93] is valid if [3.10] != 'no' or [3.93] != 'no', or alternatively if one of the following conditions is met: if [3.26] is present and negative, then [3.84] equals the positive equivalent of [3.26]; otherwise, if [3.26] is absent and [3.73] is negative then [3.84] equals the positive equivalent of [3.73]
</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-NET-PROFIT-FOR-YEAR.0">6627</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-NET-PROFIT-FOR-YEAR.0">box [3.83] is valid if [3.10] != 'no' or [3.93] != 'no', or alternatively if one of the following conditions is met: if [3.26] is present and non-negative, then this must equal [3.26]; otherwise, if [3.26] is absent and [3.73] is non-negative then this must equal [3.73]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-NET-PROFIT-FOR-YEAR.0">box [3.83] is valid if [3.10] != 'no' or [3.93] != 'no', or alternatively if one of the following conditions is met: if [3.26] is present and non-negative, then this must equal [3.26]; otherwise, if [3.26] is absent and [3.73] is non-negative then this must equal [3.73]</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-ALLOWABLE-LOSS-FOR-YEAR.1">6629</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-ALLOWABLE-LOSS-FOR-YEAR.1">If [3.84] is a loss [3.83] must be absent or zero. If [3.83] is a profit then [3.84] must be absent or zero.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-ALLOWABLE-LOSS-FOR-YEAR.1">If [3.84] is a loss [3.83] must be absent or zero. If [3.83] is a profit then [3.84] must be absent or zero.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTP-ESTIMATED-FIGURES-SIG.1">6903</sch:diagnostic>
    <sch:diagnostic id="transactional.PTP-ESTIMATED-FIGURES-SIG.1">There is an entry in box [3.93]. Please complete box [10.1].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTP-ESTIMATED-FIGURES-SIG.1">There is an entry in box [3.93]. Please complete box [10.1].</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-TOTAL-ASSETS.0">6631</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-TOTAL-ASSETS.0">The amount in box [3.105] must equal ( the sum of [3.99], [3.100], [3.101], [3.102], [3.103], and [3.104] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-TOTAL-ASSETS.0">The amount in box [3.105] must equal ( the sum of [3.99], [3.100], [3.101], [3.102], [3.103], and [3.104] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-TOTAL-LIABILITIES.0">6632</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-TOTAL-LIABILITIES.0">The amount in box [3.109] must equal ( the sum of [3.106], [3.107], and [3.108] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-TOTAL-LIABILITIES.0">The amount in box [3.109] must equal ( the sum of [3.106], [3.107], and [3.108] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-NET-BUSINESS-ASSETS.0">6633</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-NET-BUSINESS-ASSETS.0">The amount in box [3.110] must equal ( [3.105] minus [3.109] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-NET-BUSINESS-ASSETS.0">The amount in box [3.110] must equal ( [3.105] minus [3.109] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-BAL-END-PERIOD.0">6634</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-BAL-END-PERIOD.0">The amount in box [3.115] must equal ( ( the sum of [3.111], [3.112], and [3.113] ) minus [3.114] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-BAL-END-PERIOD.0">The amount in box [3.115] must equal ( ( the sum of [3.111], [3.112], and [3.113] ) minus [3.114] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-PARTNERSHIP-STMT.1">6904</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-PARTNERSHIP-STMT.1">The amount in box [N1.11] must equal the amount in box [3.83]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-PARTNERSHIP-STMT.1">The amount in box [N1.11] must equal the amount in box [3.83]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-PARTNERSHIP-STMT.2">6905</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-PARTNERSHIP-STMT.2">The amount in box [N1.12] must equal the amount in box [3.84]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-PARTNERSHIP-STMT.2">The amount in box [N1.12] must equal the amount in box [3.84]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-PARTNERSHIP-STMT.3">6906</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-PARTNERSHIP-STMT.3">The amount in box [N1.13] must equal the amount in box [7.6]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-PARTNERSHIP-STMT.3">The amount in box [N1.13] must equal the amount in box [7.6]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-PARTNERSHIP-STMT.4">6907</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-PARTNERSHIP-STMT.4">The amount in box [N1.14] must equal the amount in box [2.6]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-PARTNERSHIP-STMT.4">The amount in box [N1.14] must equal the amount in box [2.6]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-PARTNERSHIP-STMT.5">6908</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-PARTNERSHIP-STMT.5">The amount in box [N1.15] must equal the amount in box [7.26]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-PARTNERSHIP-STMT.5">The amount in box [N1.15] must equal the amount in box [7.26]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-PARTNERSHIP-STMT.6">6909</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-PARTNERSHIP-STMT.6">The amount in box [N1.16] must equal the amount in box [7.27]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-PARTNERSHIP-STMT.6">The amount in box [N1.16] must equal the amount in box [7.27]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-PARTNERSHIP-STMT.7">6910</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-PARTNERSHIP-STMT.7">The amount in box [N1.17] must equal the amount in box [2.7]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-PARTNERSHIP-STMT.7">The amount in box [N1.17] must equal the amount in box [2.7]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-PARTNERSHIP-STMT.8">6911</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-PARTNERSHIP-STMT.8">The amount in box [N1.18] must equal the amount in box [2.9]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-PARTNERSHIP-STMT.8">The amount in box [N1.18] must equal the amount in box [2.9]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-PARTNERSHIP-STMT.9">6912</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-PARTNERSHIP-STMT.9">The amount in box [N1.19] must equal the amount in box [1.39]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-PARTNERSHIP-STMT.9">The amount in box [N1.19] must equal the amount in box [1.39]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-PARTNERSHIP-STMT.12">6915</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-PARTNERSHIP-STMT.12">The amount in box [N1.21] must equal the amount in box [2.10].Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-PARTNERSHIP-STMT.12">The amount in box [N1.21] must equal the amount in box [2.10].Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-PARTNERSHIP-STMT.13">6916</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-PARTNERSHIP-STMT.13">The amount in box [N1.22] must equal the amount in box [7.18]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-PARTNERSHIP-STMT.13">The amount in box [N1.22] must equal the amount in box [7.18]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-PARTNERSHIP-STMT.14">6917</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-PARTNERSHIP-STMT.14">The amount in box [N1.23] must equal the amount in box [7.30]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-PARTNERSHIP-STMT.14">The amount in box [N1.23] must equal the amount in box [7.30]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-PARTNERSHIP-STMT.14a">6964</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-PARTNERSHIP-STMT.14a">The amount in box [N1.24] must equal the amount in box [3.97]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-PARTNERSHIP-STMT.14a">The amount in box [N1.24] must equal the amount in box [3.97]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-PARTNERSHIP-STMT.15">6948</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-PARTNERSHIP-STMT.15">The amount in box [N1.25] must equal the sum of [7.17], [7.29] and [1.22]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-PARTNERSHIP-STMT.15">The amount in box [N1.25] must equal the sum of [7.17], [7.29] and [1.22]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-PARTNERSHIP-STMT.20">6919</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-PARTNERSHIP-STMT.20">The amount in box [N1.28] must equal the amount in box [2.8]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-PARTNERSHIP-STMT.20">The amount in box [N1.28] must equal the amount in box [2.8]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-PARTNERSHIP-STMT.18">6920</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-PARTNERSHIP-STMT.18">The amount in box [N1.29] must equal the amount in box [3.117]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-PARTNERSHIP-STMT.18">The amount in box [N1.29] must equal the amount in box [3.117]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-PARTNERSHIP-STMT.19">6921</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-PARTNERSHIP-STMT.19">The amount in box [N1.30] must equal the amount in box [4.1]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-PARTNERSHIP-STMT.19">The amount in box [N1.30] must equal the amount in box [4.1]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-PARTNERSHIP-STMT.21">6922</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-PARTNERSHIP-STMT.21">The amount in box [N1.11A] must equal the amount in box [3.82]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-PARTNERSHIP-STMT.21">The amount in box [N1.11A] must equal the amount in box [3.82]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-PARTNERSHIP-STMT.22">6923</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-PARTNERSHIP-STMT.22">The amount in box [N1.22A] must equal the amount in box [7.23]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-PARTNERSHIP-STMT.22">The amount in box [N1.22A] must equal the amount in box [7.23]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-PARTNERSHIP-STMT.24">8428</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-PARTNERSHIP-STMT.24">The amount in box [N1.14A] must equal the amount in box [2.6A]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-PARTNERSHIP-STMT.24">The amount in box [N1.14A] must equal the amount in box [2.6A]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-PARTNERSHIP-STMT.25">8449</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-PARTNERSHIP-STMT.25">If [Partnership statement] is present the amount in box [N1.26] must be less than or equal to the amount in box [1.40]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-PARTNERSHIP-STMT.25">If [Partnership statement] is present the amount in box [N1.26] must be less than or equal to the amount in box [1.40]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-PARTNERSHIP-STMT.26">8450</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-PARTNERSHIP-STMT.26">If [Partnership statement] is present the amount in box [N1.27] must be less than or equal to the amount in box [2.10A]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-PARTNERSHIP-STMT.26">If [Partnership statement] is present the amount in box [N1.27] must be less than or equal to the amount in box [2.10A]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-PARTNERSHIP-STMT.27">8451</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-PARTNERSHIP-STMT.27">The amount in box [N1.26] must be equal to the total of all the amounts in the [N2.26] boxes. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-PARTNERSHIP-STMT.27">The amount in box [N1.26] must be equal to the total of all the amounts in the [N2.26] boxes. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-PARTNERSHIP-STMT.28">8452</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-PARTNERSHIP-STMT.28">The total of all occurrences of [N2.27] must equal [N1.27].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-PARTNERSHIP-STMT.28">The total of all occurrences of [N2.27] must equal [N1.27].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSF-NET-PROFIT-FOR-YEAR.0">6924</sch:diagnostic>
    <sch:diagnostic id="transactional.PSF-NET-PROFIT-FOR-YEAR.0">The sum of all occurrences of box [N2.11] must equal the amount in box [N1.11]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSF-NET-PROFIT-FOR-YEAR.0">The sum of all occurrences of box [N2.11] must equal the amount in box [N1.11]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSF-ALLOWABLE-LOSS-FOR-YEAR.0">6925</sch:diagnostic>
    <sch:diagnostic id="transactional.PSF-ALLOWABLE-LOSS-FOR-YEAR.0">The sum of all occurrences of box [N2.12] must equal the amount in box [N1.12]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSF-ALLOWABLE-LOSS-FOR-YEAR.0">The sum of all occurrences of box [N2.12] must equal the amount in box [N1.12]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSF-TOTAL-UNTAXED-INTEREST.0">6926</sch:diagnostic>
    <sch:diagnostic id="transactional.PSF-TOTAL-UNTAXED-INTEREST.0">The sum of all occurrences of box [N2.13] must equal the amount in box [N1.13]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSF-TOTAL-UNTAXED-INTEREST.0">The sum of all occurrences of box [N2.13] must equal the amount in box [N1.13]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSF-UNTAXED-FOREIGN-SAVINGS.0">6927</sch:diagnostic>
    <sch:diagnostic id="transactional.PSF-UNTAXED-FOREIGN-SAVINGS.0">The sum of all occurrences of box [N2.14] must equal the amount in box [N1.14]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSF-UNTAXED-FOREIGN-SAVINGS.0">The sum of all occurrences of box [N2.14] must equal the amount in box [N1.14]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSF-OTHER-UNTAXED-UK-INCOME.0">6928</sch:diagnostic>
    <sch:diagnostic id="transactional.PSF-OTHER-UNTAXED-UK-INCOME.0">The sum of all occurrences of box [N2.15] must equal the amount in box [N1.15]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSF-OTHER-UNTAXED-UK-INCOME.0">The sum of all occurrences of box [N2.15] must equal the amount in box [N1.15]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSF-OTHER-UNTAXED-UK-INC-LOSS.0">6929</sch:diagnostic>
    <sch:diagnostic id="transactional.PSF-OTHER-UNTAXED-UK-INC-LOSS.0">The sum of all occurrences of box [N2.16] must equal the amount in box [N1.16]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSF-OTHER-UNTAXED-UK-INC-LOSS.0">The sum of all occurrences of box [N2.16] must equal the amount in box [N1.16]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSF-OTHER-UNTAXED-FOREIGN-INC.0">6930</sch:diagnostic>
    <sch:diagnostic id="transactional.PSF-OTHER-UNTAXED-FOREIGN-INC.0">The sum of all occurrences of box [N2.17] must equal the amount in box [N1.17]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSF-OTHER-UNTAXED-FOREIGN-INC.0">The sum of all occurrences of box [N2.17] must equal the amount in box [N1.17]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSF-INCOME-OFFSHORE-FUNDS.0">6931</sch:diagnostic>
    <sch:diagnostic id="transactional.PSF-INCOME-OFFSHORE-FUNDS.0">The sum of all occurrences of box [N2.18] must equal the amount in box [N1.18]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSF-INCOME-OFFSHORE-FUNDS.0">The sum of all occurrences of box [N2.18] must equal the amount in box [N1.18]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSF-PPTY-PROFIT-LOSS-FOR-PRD.0">6932</sch:diagnostic>
    <sch:diagnostic id="transactional.PSF-PPTY-PROFIT-LOSS-FOR-PRD.0">The sum of all occurrences of box [N2.19] must equal the amount in box [N1.19]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSF-PPTY-PROFIT-LOSS-FOR-PRD.0">The sum of all occurrences of box [N2.19] must equal the amount in box [N1.19]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSF-FOREIGN-LET-PROPERTY-LOSS.0">6935</sch:diagnostic>
    <sch:diagnostic id="transactional.PSF-FOREIGN-LET-PROPERTY-LOSS.0">The sum of all occurrences of box [N2.21] must equal the amount in box [N1.21]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSF-FOREIGN-LET-PROPERTY-LOSS.0">The sum of all occurrences of box [N2.21] must equal the amount in box [N1.21]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSF-TOTAL-TAXED-SAVINGS.0">6936</sch:diagnostic>
    <sch:diagnostic id="transactional.PSF-TOTAL-TAXED-SAVINGS.0">The sum of all occurrences of box [N2.22] must equal the amount in box [N1.22]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSF-TOTAL-TAXED-SAVINGS.0">The sum of all occurrences of box [N2.22] must equal the amount in box [N1.22]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSF-OTHER-OI-BEFORE-TAX-DED.0">6937</sch:diagnostic>
    <sch:diagnostic id="transactional.PSF-OTHER-OI-BEFORE-TAX-DED.0">The sum of all occurrences of box [N2.23] must equal the amount in box [N1.23]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSF-OTHER-OI-BEFORE-TAX-DED.0">The sum of all occurrences of box [N2.23] must equal the amount in box [N1.23]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSF-SUB-CON-DEDUCTION.0">6938</sch:diagnostic>
    <sch:diagnostic id="transactional.PSF-SUB-CON-DEDUCTION.0">The sum of all occurrences of box [N2.24] must equal the amount in box [N1.24]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSF-SUB-CON-DEDUCTION.0">The sum of all occurrences of box [N2.24] must equal the amount in box [N1.24]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSF-UK-INCOME-TAX.0">6939</sch:diagnostic>
    <sch:diagnostic id="transactional.PSF-UK-INCOME-TAX.0">The sum of all occurrences of box [N2.25] must equal the amount in box [N1.25]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSF-UK-INCOME-TAX.0">The sum of all occurrences of box [N2.25] must equal the amount in box [N1.25]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSF-TOTAL-FOREIGN-TAX-PAID.0">6942</sch:diagnostic>
    <sch:diagnostic id="transactional.PSF-TOTAL-FOREIGN-TAX-PAID.0">The sum of all occurrences of box [N2.28] must equal the amount in box [N1.28]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSF-TOTAL-FOREIGN-TAX-PAID.0">The sum of all occurrences of box [N2.28] must equal the amount in box [N1.28]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSF-NET-PSHIP-CHARGES-PAID.0">6943</sch:diagnostic>
    <sch:diagnostic id="transactional.PSF-NET-PSHIP-CHARGES-PAID.0">The sum of all occurrences of box [N2.29] must equal the amount in box [N1.29]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSF-NET-PSHIP-CHARGES-PAID.0">The sum of all occurrences of box [N2.29] must equal the amount in box [N1.29]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSF-TOT-DISPOSAL-CHRGBLE-ASSET.0">6944</sch:diagnostic>
    <sch:diagnostic id="transactional.PSF-TOT-DISPOSAL-CHRGBLE-ASSET.0">The sum of all occurrences of box [N2.30] must equal the amount in box [N1.30]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSF-TOT-DISPOSAL-CHRGBLE-ASSET.0">The sum of all occurrences of box [N2.30] must equal the amount in box [N1.30]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSF3-CHANGE-OF-BASIS-ADJ.0">6945</sch:diagnostic>
    <sch:diagnostic id="transactional.PSF3-CHANGE-OF-BASIS-ADJ.0">The sum of all occurrences of box [N2.11A] must equal the amount in box [N1.11A]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSF3-CHANGE-OF-BASIS-ADJ.0">The sum of all occurrences of box [N2.11A] must equal the amount in box [N1.11A]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSF3-TOT-SCHF-TAXED-SAVINGS.0">6946</sch:diagnostic>
    <sch:diagnostic id="transactional.PSF3-TOT-SCHF-TAXED-SAVINGS.0">The sum of all occurrences of box [N2.22A] must equal the amount in box [N1.22A]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSF3-TOT-SCHF-TAXED-SAVINGS.0">The sum of all occurrences of box [N2.22A] must equal the amount in box [N1.22A]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSF4-FOREIGN-DIVIDENDS-AMOUNT.0">8322</sch:diagnostic>
    <sch:diagnostic id="transactional.PSF4-FOREIGN-DIVIDENDS-AMOUNT.0">The sum of all occurrences of box [N2.14A] must equal the amount in box [N1.14A]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSF4-FOREIGN-DIVIDENDS-AMOUNT.0">The sum of all occurrences of box [N2.14A] must equal the amount in box [N1.14A]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSF-ACCOUNT-PERIOD-END-DATE.0">6635</sch:diagnostic>
    <sch:diagnostic id="transactional.PSF-ACCOUNT-PERIOD-END-DATE.0">The date in box [N1.2] cannot be earlier than the date in box [N1.1]. Please amend the incorrect entry.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSF-ACCOUNT-PERIOD-END-DATE.0">The date in box [N1.2] cannot be earlier than the date in box [N1.1]. Please amend the incorrect entry.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSF-CORPORATION-TAX-RULES-SIG.0">8554</sch:diagnostic>
    <sch:diagnostic id="transactional.PSF-CORPORATION-TAX-RULES-SIG.0">If there in an entry in box [N1.4] and at least one entry in [2.11] is present then [2.8A] must be submitted. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSF-CORPORATION-TAX-RULES-SIG.0">If there in an entry in box [N1.4] and at least one entry in [2.11] is present then [2.8A] must be submitted. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSF-NET-PROFIT-FOR-YEAR-FT-SIG.0">6636</sch:diagnostic>
    <sch:diagnostic id="transactional.PSF-NET-PROFIT-FOR-YEAR-FT-SIG.0">There is an entry in box [N1.A]. Please complete box [N1.11].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSF-NET-PROFIT-FOR-YEAR-FT-SIG.0">There is an entry in box [N1.A]. Please complete box [N1.11].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSF-ALLOWABLE-LOSS-YEAR-FT-SIG.0">6637</sch:diagnostic>
    <sch:diagnostic id="transactional.PSF-ALLOWABLE-LOSS-YEAR-FT-SIG.0">There is an entry in box [N1.B]. Please complete box [N1.12].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSF-ALLOWABLE-LOSS-YEAR-FT-SIG.0">There is an entry in box [N1.B]. Please complete box [N1.12].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSF-UNTAXED-FOREIGN-FT-SIG.0">6638</sch:diagnostic>
    <sch:diagnostic id="transactional.PSF-UNTAXED-FOREIGN-FT-SIG.0">There is an entry in box [N1.C]. Please complete box [N1.14].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSF-UNTAXED-FOREIGN-FT-SIG.0">There is an entry in box [N1.C]. Please complete box [N1.14].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSF-OTHER-UNTAXED-F-INC-FT-SIG.0">6639</sch:diagnostic>
    <sch:diagnostic id="transactional.PSF-OTHER-UNTAXED-F-INC-FT-SIG.0">There is an entry in box [N1.D]. Please complete box [N1.17].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSF-OTHER-UNTAXED-F-INC-FT-SIG.0">There is an entry in box [N1.D]. Please complete box [N1.17].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSF-INC-OFFSHORE-FUNDS-FT-SIG.0">6640</sch:diagnostic>
    <sch:diagnostic id="transactional.PSF-INC-OFFSHORE-FUNDS-FT-SIG.0">There is an entry in box [N1.E]. Please complete box [N1.18].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSF-INC-OFFSHORE-FUNDS-FT-SIG.0">There is an entry in box [N1.E]. Please complete box [N1.18].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSF-OTHER-OI-BEFORE-TAX-FT-SIG.0">6641</sch:diagnostic>
    <sch:diagnostic id="transactional.PSF-OTHER-OI-BEFORE-TAX-FT-SIG.0">There is an entry in box [N1.H]. Please complete box [N1.23].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSF-OTHER-OI-BEFORE-TAX-FT-SIG.0">There is an entry in box [N1.H]. Please complete box [N1.23].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PPS-PARTNER-REF-NUMBER.1">6965</sch:diagnostic>
    <sch:diagnostic id="transactional.PPS-PARTNER-REF-NUMBER.1">The entry must be 10 numeric characters, but not 1111111111, 2222222222, 3333333333, 4444444444, 5555555555, 6666666666, 7777777777, 8888888888, 9999999999. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PPS-PARTNER-REF-NUMBER.1">The entry must be 10 numeric characters, but not 1111111111, 2222222222, 3333333333, 4444444444, 5555555555, 6666666666, 7777777777, 8888888888, 9999999999. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PPS-PARTNER-REF-NUMBER.0">8205</sch:diagnostic>
    <sch:diagnostic id="transactional.PPS-PARTNER-REF-NUMBER.0">The entry must be valid against the UTR algorithm. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PPS-PARTNER-REF-NUMBER.0">The entry must be valid against the UTR algorithm. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PPS-CEASED-PARTNER-DATE.0">6642</sch:diagnostic>
    <sch:diagnostic id="transactional.PPS-CEASED-PARTNER-DATE.0">The date in box [N2.9] cannot be earlier than the date in box [N2.7]. Please amend the incorrect entry.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PPS-CEASED-PARTNER-DATE.0">The date in box [N2.9] cannot be earlier than the date in box [N2.7]. Please amend the incorrect entry.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTF-TAXPAYER-ADDRESS.0">8239</sch:diagnostic>
    <sch:diagnostic id="transactional.PTF-TAXPAYER-ADDRESS.0">There is an entry in A11. Please complete A12.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTF-TAXPAYER-ADDRESS.0">There is an entry in A11. Please complete A12.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTF-TAXPAYER-ADDRESS.1">8240</sch:diagnostic>
    <sch:diagnostic id="transactional.PTF-TAXPAYER-ADDRESS.1">There is an entry in A14. Please complete A11, A12 and A13.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTF-TAXPAYER-ADDRESS.1">There is an entry in A14. Please complete A11, A12 and A13.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PTNR-TAX-AVOIDANCE-SCHEMES.0">8241</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PTNR-TAX-AVOIDANCE-SCHEMES.0">Each repetition of [Tax avoidance schemes] must contain at least one of either [10.2] or [10.3]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PTNR-TAX-AVOIDANCE-SCHEMES.0">Each repetition of [Tax avoidance schemes] must contain at least one of either [10.2] or [10.3]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PLP-PERIOD-START-DATE.0">6884</sch:diagnostic>
    <sch:diagnostic id="transactional.PLP-PERIOD-START-DATE.0">The date in box [1.1] must be the same as the date in box [3.4]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PLP-PERIOD-START-DATE.0">The date in box [1.1] must be the same as the date in box [3.4]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PLP-PERIOD-END-DATE.1">6885</sch:diagnostic>
    <sch:diagnostic id="transactional.PLP-PERIOD-END-DATE.1">The date in box [1.2] must be the same as the date in box [3.5]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PLP-PERIOD-END-DATE.1">The date in box [1.2] must be the same as the date in box [3.5]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PLP3-PPTY-TOTAL-INCOME.global.14">8278</sch:diagnostic>
    <sch:diagnostic id="transactional.PLP3-PPTY-TOTAL-INCOME.global.14">There is an entry in box [1.21]. Please complete box [1.24].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PLP3-PPTY-TOTAL-INCOME.global.14">There is an entry in box [1.21]. Please complete box [1.24].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PLP-PPTY-TOTAL-EXPENDITURE.global.15">6971</sch:diagnostic>
    <sch:diagnostic id="transactional.PLP-PPTY-TOTAL-EXPENDITURE.global.15">There is an entry in [1.25] or [1.26] or [1.27] or [1.28] or [1.29] or [1.30]. Please complete box [1.31].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PLP-PPTY-TOTAL-EXPENDITURE.global.15">There is an entry in [1.25] or [1.26] or [1.27] or [1.28] or [1.29] or [1.30]. Please complete box [1.31].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PLP-PPTY-NET-PROFIT-LOSS.global.16">6972</sch:diagnostic>
    <sch:diagnostic id="transactional.PLP-PPTY-NET-PROFIT-LOSS.global.16">There is an entry in [1.24] or [1.31]. Please complete box [1.32].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PLP-PPTY-NET-PROFIT-LOSS.global.16">There is an entry in [1.24] or [1.31]. Please complete box [1.32].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PLP-PPTY-TOTAL-ADDITIONS.global.17">6973</sch:diagnostic>
    <sch:diagnostic id="transactional.PLP-PPTY-TOTAL-ADDITIONS.global.17">There is an entry in [1.33] or [1.34]. Please complete box [1.35].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PLP-PPTY-TOTAL-ADDITIONS.global.17">There is an entry in [1.33] or [1.34]. Please complete box [1.35].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PLP-PPTY-PROFIT-LOSS-FOR-PRD.global.19">6975</sch:diagnostic>
    <sch:diagnostic id="transactional.PLP-PPTY-PROFIT-LOSS-FOR-PRD.global.19">There is an entry in [1.32] or [1.35] or [1.38]. Please complete box [1.39].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PLP-PPTY-PROFIT-LOSS-FOR-PRD.global.19">There is an entry in [1.32] or [1.35] or [1.38]. Please complete box [1.39].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA801.0">8279</sch:diagnostic>
    <sch:diagnostic id="transactional.SA801.0">There is an entry in box [1.1]. Please complete box [1.2].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA801.0">There is an entry in box [1.1]. Please complete box [1.2].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA801.1">8280</sch:diagnostic>
    <sch:diagnostic id="transactional.SA801.1">There is an entry in box [1.23]. Please complete box [1.24].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA801.1">There is an entry in box [1.23]. Please complete box [1.24].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA801.2">8281</sch:diagnostic>
    <sch:diagnostic id="transactional.SA801.2">There is an entry in box [1.23A]. Please complete box [1.24].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA801.2">There is an entry in box [1.23A]. Please complete box [1.24].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PLP-PERIOD-END-DATE.0">6671</sch:diagnostic>
    <sch:diagnostic id="transactional.PLP-PERIOD-END-DATE.0">The date in box [1.2] cannot be earlier than the date in box[1.1]. Please amend the incorrect entry.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PLP-PERIOD-END-DATE.0">The date in box [1.2] cannot be earlier than the date in box[1.1]. Please amend the incorrect entry.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PLP3-PPTY-TOTAL-INCOME.0">8287</sch:diagnostic>
    <sch:diagnostic id="transactional.PLP3-PPTY-TOTAL-INCOME.0">The amount in box [1.24] must equal ( the sum of [1.21], [1.23], and [1.23A] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PLP3-PPTY-TOTAL-INCOME.0">The amount in box [1.24] must equal ( the sum of [1.21], [1.23], and [1.23A] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PLP3-PPTY-TOTAL-INCOME.1">6658</sch:diagnostic>
    <sch:diagnostic id="transactional.PLP3-PPTY-TOTAL-INCOME.1">There is an entry in [1.24]. Please complete [1.1].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PLP3-PPTY-TOTAL-INCOME.1">There is an entry in [1.24]. Please complete [1.1].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PLP3-PPTY-TOTAL-INCOME.2">8562</sch:diagnostic>
    <sch:diagnostic id="transactional.PLP3-PPTY-TOTAL-INCOME.2">There must be an entry in [1.22A] if there is an entry in [N1.4]  and [1.24] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PLP3-PPTY-TOTAL-INCOME.2">There must be an entry in [1.22A] if there is an entry in [N1.4]  and [1.24] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PLP-PPTY-TOTAL-EXPENDITURE.0">6682</sch:diagnostic>
    <sch:diagnostic id="transactional.PLP-PPTY-TOTAL-EXPENDITURE.0">The amount in box [1.31] must equal the sum of [1.25], [1.26], [1.27], [1.28], [1.29], and [1.30]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PLP-PPTY-TOTAL-EXPENDITURE.0">The amount in box [1.31] must equal the sum of [1.25], [1.26], [1.27], [1.28], [1.29], and [1.30]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PLP-PPTY-NET-PROFIT-LOSS.0">6683</sch:diagnostic>
    <sch:diagnostic id="transactional.PLP-PPTY-NET-PROFIT-LOSS.0">The amount in box [1.32] must equal [1.24] minus [1.31]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PLP-PPTY-NET-PROFIT-LOSS.0">The amount in box [1.32] must equal [1.24] minus [1.31]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PLP-PPTY-TOTAL-ADDITIONS.0">6684</sch:diagnostic>
    <sch:diagnostic id="transactional.PLP-PPTY-TOTAL-ADDITIONS.0">The amount in box [1.35] must equal [1.33] plus [1.34]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PLP-PPTY-TOTAL-ADDITIONS.0">The amount in box [1.35] must equal [1.33] plus [1.34]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PLP-NET-PROFIT-DEDUCTIONS.0">8371</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PLP-NET-PROFIT-DEDUCTIONS.0">There is an entry in [1.35A]. Please complete [1.38]. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PLP-NET-PROFIT-DEDUCTIONS.0">There is an entry in [1.35A]. Please complete [1.38]. </sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PLP-NET-PROFIT-DEDUCTIONS.1">8374</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PLP-NET-PROFIT-DEDUCTIONS.1">There is an entry in [1.35B]. Please complete [1.38]. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PLP-NET-PROFIT-DEDUCTIONS.1">There is an entry in [1.35B]. Please complete [1.38]. </sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PLP-NET-PROFIT-DEDUCTIONS.2">8375</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PLP-NET-PROFIT-DEDUCTIONS.2">There is an entry in [1.35C]. Please complete [1.38]. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PLP-NET-PROFIT-DEDUCTIONS.2">There is an entry in [1.35C]. Please complete [1.38]. </sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PLP-NET-PROFIT-DEDUCTIONS.3">8376</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PLP-NET-PROFIT-DEDUCTIONS.3">There is an entry in [1.35D]. Please complete [1.38]. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PLP-NET-PROFIT-DEDUCTIONS.3">There is an entry in [1.35D]. Please complete [1.38]. </sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PLP-NET-PROFIT-DEDUCTIONS.4">8377</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PLP-NET-PROFIT-DEDUCTIONS.4">There is an entry in [1.35E]. Please complete [1.38]. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PLP-NET-PROFIT-DEDUCTIONS.4">There is an entry in [1.35E]. Please complete [1.38]. </sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PLP-NET-PROFIT-DEDUCTIONS.5">8372</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PLP-NET-PROFIT-DEDUCTIONS.5">There is an entry in [1.36]. Please complete [1.38].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PLP-NET-PROFIT-DEDUCTIONS.5">There is an entry in [1.36]. Please complete [1.38].</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PLP-NET-PROFIT-DEDUCTIONS.6">8373</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PLP-NET-PROFIT-DEDUCTIONS.6">There is an entry in [1.37]. Please complete [1.38].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PLP-NET-PROFIT-DEDUCTIONS.6">There is an entry in [1.37]. Please complete [1.38].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PLP-ANNUAL-INV-ALLCE-AMT.1">8563</sch:diagnostic>
    <sch:diagnostic id="transactional.PLP-ANNUAL-INV-ALLCE-AMT.1">The entry in box [1.35A] should not be present there is no entry in [1.22A] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PLP-ANNUAL-INV-ALLCE-AMT.1">The entry in box [1.35A] should not be present there is no entry in [1.22A] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PLP-ANNUAL-INV-ALLCE-AMT.0">6660</sch:diagnostic>
    <sch:diagnostic id="transactional.PLP-ANNUAL-INV-ALLCE-AMT.0">[1.35A] is valid only if this does not exceed [£1,500,000]</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PLP-ANNUAL-INV-ALLCE-AMT.0">[1.35A] is valid only if this does not exceed [£1,500,000]</sch:diagnostic>
    <sch:diagnostic id="errorCode.PLP-PPTY-TOTAL-DEDUCTIONS.0">6687</sch:diagnostic>
    <sch:diagnostic id="transactional.PLP-PPTY-TOTAL-DEDUCTIONS.0">The amount in box [1.38] must equal the sum of ( [1.35A], [1.35B], [1.35C], [1.35D], [1.35E], [1.36], and [1.37] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PLP-PPTY-TOTAL-DEDUCTIONS.0">The amount in box [1.38] must equal the sum of ( [1.35A], [1.35B], [1.35C], [1.35D], [1.35E], [1.36], and [1.37] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PLP-PPTY-PROFIT-LOSS-FOR-PRD.1">6951</sch:diagnostic>
    <sch:diagnostic id="transactional.PLP-PPTY-PROFIT-LOSS-FOR-PRD.1">There is an entry in box [1.39]. Please complete [1.1].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PLP-PPTY-PROFIT-LOSS-FOR-PRD.1">There is an entry in box [1.39]. Please complete [1.1].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PLP-PPTY-PROFIT-LOSS-FOR-PRD.2">6688</sch:diagnostic>
    <sch:diagnostic id="transactional.PLP-PPTY-PROFIT-LOSS-FOR-PRD.2">The amount in box [1.39] must equal ( ( [1.32] plus [1.35] ) minus [1.38] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PLP-PPTY-PROFIT-LOSS-FOR-PRD.2">The amount in box [1.39] must equal ( ( [1.32] plus [1.35] ) minus [1.38] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PFI-FOREIGN-PERIOD-START-DATE.0">6645</sch:diagnostic>
    <sch:diagnostic id="transactional.PFI-FOREIGN-PERIOD-START-DATE.0">The date in box [2.4] must be the same as the date in box [3.4]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PFI-FOREIGN-PERIOD-START-DATE.0">The date in box [2.4] must be the same as the date in box [3.4]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PFI-FOREIGN-PERIOD-START-DATE.1">6982</sch:diagnostic>
    <sch:diagnostic id="transactional.PFI-FOREIGN-PERIOD-START-DATE.1">The date in box [2.5] must be the same as the date in box [3.5]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PFI-FOREIGN-PERIOD-START-DATE.1">The date in box [2.5] must be the same as the date in box [3.5]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PFI-OTHER-UNTAXED-FOREIGN-INC.global.20">6983</sch:diagnostic>
    <sch:diagnostic id="transactional.PFI-OTHER-UNTAXED-FOREIGN-INC.global.20">There is an entry in [2.3A.3]. Please complete box [2.7].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PFI-OTHER-UNTAXED-FOREIGN-INC.global.20">There is an entry in [2.3A.3]. Please complete box [2.7].</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PFI-TOTAL-FOREIGN-TAX.global.27">6988</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PFI-TOTAL-FOREIGN-TAX.global.27">There is an entry in [2.4.3]. Please complete box [2.32].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PFI-TOTAL-FOREIGN-TAX.global.27">There is an entry in [2.4.3]. Please complete box [2.32].</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PFI-TOTAL-AMT-CHRGBL.global.28">6989</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PFI-TOTAL-AMT-CHRGBL.global.28">There is an entry in [2.4.4]. Please complete box [2.33].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PFI-TOTAL-AMT-CHRGBL.global.28">There is an entry in [2.4.4]. Please complete box [2.33].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SA802.0">8564</sch:diagnostic>
    <sch:diagnostic id="transactional.SA802.0">If there is no entry in [2.8A] then the sum of all instances of ( [2.11] + [2.21] ) must not exceed [£150,000] Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SA802.0">If there is no entry in [2.8A] then the sum of all instances of ( [2.11] + [2.21] ) must not exceed [£150,000] Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PFI-FGN-INC-SAVINGS-LAND-PPTY.0">6689</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PFI-FGN-INC-SAVINGS-LAND-PPTY.0">An entry in box [2.4] must be present as there is an entry in one or more of boxes [2.6], [2.6A], [2.7], [2.8], [2.9], [2.10]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PFI-FGN-INC-SAVINGS-LAND-PPTY.0">An entry in box [2.4] must be present as there is an entry in one or more of boxes [2.6], [2.6A], [2.7], [2.8], [2.9], [2.10]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PFI-FGN-INC-SAVINGS-LAND-PPTY.1">8243</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PFI-FGN-INC-SAVINGS-LAND-PPTY.1">There are entries in [2.2.1 Country/2.2.2 Unremittable/2.2.3 Gross/2.2.4 Foreign Tax -] with no corresponding entry in "Unremittable tickbox of [2.2.1 Country/2.2.2 Unremittable/2.2.3 Gross/2.2.4 Foreign Tax -]". Please complete box [2.6].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PFI-FGN-INC-SAVINGS-LAND-PPTY.1">There are entries in [2.2.1 Country/2.2.2 Unremittable/2.2.3 Gross/2.2.4 Foreign Tax -] with no corresponding entry in "Unremittable tickbox of [2.2.1 Country/2.2.2 Unremittable/2.2.3 Gross/2.2.4 Foreign Tax -]". Please complete box [2.6].</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PFI-FGN-INC-SAVINGS-LAND-PPTY.2">8244</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PFI-FGN-INC-SAVINGS-LAND-PPTY.2">There are entries in [2.2A.1 Country/2.2A.2 Unremittable/2.2A.3 Gross/2.2A.4 Foreign Tax -] with no corresponding entry in "Unremittable tickbox of [2.2A.1 Country/2.2A.2 Unremittable/2.2A.3 Gross/2.2A.4 Foreign Tax -]". Please complete box [2.6A].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PFI-FGN-INC-SAVINGS-LAND-PPTY.2">There are entries in [2.2A.1 Country/2.2A.2 Unremittable/2.2A.3 Gross/2.2A.4 Foreign Tax -] with no corresponding entry in "Unremittable tickbox of [2.2A.1 Country/2.2A.2 Unremittable/2.2A.3 Gross/2.2A.4 Foreign Tax -]". Please complete box [2.6A].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PFI-FOREIGN-PERIOD-END-DATE.0">6690</sch:diagnostic>
    <sch:diagnostic id="transactional.PFI-FOREIGN-PERIOD-END-DATE.0">The date in box [2.5] cannot be earlier than the date in box [2.4]. Please amend the incorrect entry. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PFI-FOREIGN-PERIOD-END-DATE.0">The date in box [2.5] cannot be earlier than the date in box [2.4]. Please amend the incorrect entry. </sch:diagnostic>
    <sch:diagnostic id="errorCode.PFI-UNTAXED-FOREIGN-SAVINGS.0">6647</sch:diagnostic>
    <sch:diagnostic id="transactional.PFI-UNTAXED-FOREIGN-SAVINGS.0">The amount in box [2.6] must equal the total of "Gross of [2.2.1 Country/2.2.2 Unremittable/2.2.3 Gross/2.2.4 Foreign Tax -]" entries with no corresponding tick in "Unremittable tickbox of [2.2.1 Country/2.2.2 Unremittable/2.2.3 Gross/2.2.4 Foreign Tax -]". Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PFI-UNTAXED-FOREIGN-SAVINGS.0">The amount in box [2.6] must equal the total of "Gross of [2.2.1 Country/2.2.2 Unremittable/2.2.3 Gross/2.2.4 Foreign Tax -]" entries with no corresponding tick in "Unremittable tickbox of [2.2.1 Country/2.2.2 Unremittable/2.2.3 Gross/2.2.4 Foreign Tax -]". Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PFI4-UNTAXED-FOREIGN-DIV-TOT.0">6992</sch:diagnostic>
    <sch:diagnostic id="transactional.PFI4-UNTAXED-FOREIGN-DIV-TOT.0">The amount in box [2.6A] must equal the total of "Gross of [2.2A.1 Country/2.2A.2 Unremittable/2.2A.3 Gross/2.2A.4 Foreign Tax -]" entries with no corresponding tick in "Unremittable tickbox of [2.2A.1 Country/2.2A.2 Unremittable/2.2A.3 Gross/2.2A.4 Foreign Tax -]". Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PFI4-UNTAXED-FOREIGN-DIV-TOT.0">The amount in box [2.6A] must equal the total of "Gross of [2.2A.1 Country/2.2A.2 Unremittable/2.2A.3 Gross/2.2A.4 Foreign Tax -]" entries with no corresponding tick in "Unremittable tickbox of [2.2A.1 Country/2.2A.2 Unremittable/2.2A.3 Gross/2.2A.4 Foreign Tax -]". Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PFI-LAND-PPTY-GROSS.0">8455</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PFI-LAND-PPTY-GROSS.0">There is an entry in box [2.3.3] please complete [2.28] or [2.31] </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PFI-LAND-PPTY-GROSS.0">There is an entry in box [2.3.3] please complete [2.28] or [2.31] </sch:diagnostic>
    <sch:diagnostic id="errorCode.PFI-OTHER-UNTAXED-FOREIGN-INC.0">6993</sch:diagnostic>
    <sch:diagnostic id="transactional.PFI-OTHER-UNTAXED-FOREIGN-INC.0">[2.7] must equal total of ([2.3.3] + [2.3A.3])</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PFI-OTHER-UNTAXED-FOREIGN-INC.0">[2.7] must equal total of ([2.3.3] + [2.3A.3])</sch:diagnostic>
    <sch:diagnostic id="errorCode.PFI-TOTAL-FOREIGN-TAX-PAID.0">6691</sch:diagnostic>
    <sch:diagnostic id="transactional.PFI-TOTAL-FOREIGN-TAX-PAID.0">Box [2.8] completed, an entry is required in at least one of the boxes [2.6], [2.6A] and [2.7]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PFI-TOTAL-FOREIGN-TAX-PAID.0">Box [2.8] completed, an entry is required in at least one of the boxes [2.6], [2.6A] and [2.7]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PFI-FOREIGN-LET-PROPERTY-LOSS.0">8456</sch:diagnostic>
    <sch:diagnostic id="transactional.PFI-FOREIGN-LET-PROPERTY-LOSS.0">There is an entry in box [2.10] please complete [2.29] or [2.34] </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PFI-FOREIGN-LET-PROPERTY-LOSS.0">There is an entry in box [2.10] please complete [2.29] or [2.34] </sch:diagnostic>
    <sch:diagnostic id="errorCode.PFI-RES-FIN-COSTS.0">8458</sch:diagnostic>
    <sch:diagnostic id="transactional.PFI-RES-FIN-COSTS.0">There is an entry in box [2.10A] please complete [2.30A] or [2.33A] </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PFI-RES-FIN-COSTS.0">There is an entry in box [2.10A] please complete [2.30A] or [2.33A] </sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PFI-NET-PROFIT-LOSS.global.22">6985</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PFI-NET-PROFIT-LOSS.global.22">There is an entry in [2.11] or [2.18]. Please complete box [2.19].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PFI-NET-PROFIT-LOSS.global.22">There is an entry in [2.11] or [2.18]. Please complete box [2.19].</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PFI-ADJUSTED-PROFIT.global.25">6994</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PFI-ADJUSTED-PROFIT.global.25">The sum of ( ( [2.19] plus [2.22] ) minus [2.25] ) exceeds 0. Please complete box [2.26].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PFI-ADJUSTED-PROFIT.global.25">The sum of ( ( [2.19] plus [2.22] ) minus [2.25] ) exceeds 0. Please complete box [2.26].</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PFI-ADJUSTED-LOSS.global.26">6995</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PFI-ADJUSTED-LOSS.global.26">The sum of ( ( [2.19] plus [2.22] ) minus [2.25] ) is less than 0. Please complete box [2.27].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PFI-ADJUSTED-LOSS.global.26">The sum of ( ( [2.19] plus [2.22] ) minus [2.25] ) is less than 0. Please complete box [2.27].</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PFI-TOTAL-EXPENDITURE.global.21">6984</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PFI-TOTAL-EXPENDITURE.global.21">There is an entry in [2.12] or [2.13] or [2.14] or [2.15] or [2.16] or [2.17]. Please complete box [2.18].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PFI-TOTAL-EXPENDITURE.global.21">There is an entry in [2.12] or [2.13] or [2.14] or [2.15] or [2.16] or [2.17]. Please complete box [2.18].</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PFI-TOTAL-EXPENDITURE.0">6692</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PFI-TOTAL-EXPENDITURE.0">The amount in box [2.18] must equal the sum of [2.12], [2.13], [2.14], [2.15], [2.16], and [2.17]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PFI-TOTAL-EXPENDITURE.0">The amount in box [2.18] must equal the sum of [2.12], [2.13], [2.14], [2.15], [2.16], and [2.17]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PFI-NET-PROFIT-LOSS.0">6693</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PFI-NET-PROFIT-LOSS.0">The amount in box [2.19] must equal [2.11] minus [2.18]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PFI-NET-PROFIT-LOSS.0">The amount in box [2.19] must equal [2.11] minus [2.18]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PFI-TOTAL-ADDITIONS.global.23">6986</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PFI-TOTAL-ADDITIONS.global.23">There is an entry in [2.20] or [2.21]. Please complete box [2.22].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PFI-TOTAL-ADDITIONS.global.23">There is an entry in [2.20] or [2.21]. Please complete box [2.22].</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PFI-TOTAL-ADDITIONS.0">6694</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PFI-TOTAL-ADDITIONS.0">The amount in box [2.22] must equal [2.20] plus [2.21]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PFI-TOTAL-ADDITIONS.0">The amount in box [2.22] must equal [2.20] plus [2.21]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PFI-TOTAL-DEDUCTIONS.global.24">6987</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PFI-TOTAL-DEDUCTIONS.global.24">There is an entry in [2.21A], [2.21B], [2.21C], [2.23] or [2.24]. Please complete box [2.25].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PFI-TOTAL-DEDUCTIONS.global.24">There is an entry in [2.21A], [2.21B], [2.21C], [2.23] or [2.24]. Please complete box [2.25].</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PFI-TOTAL-DEDUCTIONS.0">6695</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PFI-TOTAL-DEDUCTIONS.0">The amount in box [2.25] must equal ( the sum of [2.21A], [2.21B], [2.21C], [2.23] and [2.24] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PFI-TOTAL-DEDUCTIONS.0">The amount in box [2.25] must equal ( the sum of [2.21A], [2.21B], [2.21C], [2.23] and [2.24] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PFI-ADJUSTED-PROFIT.0">6696</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PFI-ADJUSTED-PROFIT.0">The amount in box [2.26] must equal the sum if positive, of [2.19] plus [2.22] minus [2.25], otherwise [2.26] must be zero or absent. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PFI-ADJUSTED-PROFIT.0">The amount in box [2.26] must equal the sum if positive, of [2.19] plus [2.22] minus [2.25], otherwise [2.26] must be zero or absent. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PFI-ADJUSTED-LOSS.0">8288</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PFI-ADJUSTED-LOSS.0">The amount in box [2.27] must equal the positive equivalent of the sum of [2.19] plus [2.22] minus [2.25]  if negative, otherwise [2.27] must be zero or absent. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PFI-ADJUSTED-LOSS.0">The amount in box [2.27] must equal the positive equivalent of the sum of [2.19] plus [2.22] minus [2.25]  if negative, otherwise [2.27] must be zero or absent. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.id16.0">8460</sch:diagnostic>
    <sch:diagnostic id="transactional.id16.0">There must be an entry in [2.31] equal to the total occurrences of [2.4.2] if total is positive. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.id16.0">There must be an entry in [2.31] equal to the total occurrences of [2.4.2] if total is positive. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.id16.1">8461</sch:diagnostic>
    <sch:diagnostic id="transactional.id16.1">There must be an entry in [2.34]  equal to the absolute value of the total of all occurrences of [2.4.2] if total is negative. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.id16.1">There must be an entry in [2.34]  equal to the absolute value of the total of all occurrences of [2.4.2] if total is negative. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PFI-TOTAL-FOREIGN-TAX.1">6650</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PFI-TOTAL-FOREIGN-TAX.1">Must equal the sum of all occurrences of box [2.4.3]. </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PFI-TOTAL-FOREIGN-TAX.1">Must equal the sum of all occurrences of box [2.4.3]. </sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PFI-TOTAL-AMT-CHRGBL.1">6655</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PFI-TOTAL-AMT-CHRGBL.1">Must equal the sum of all occurrences of box [2.4.4].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PFI-TOTAL-AMT-CHRGBL.1">Must equal the sum of all occurrences of box [2.4.4].</sch:diagnostic>
    <sch:diagnostic id="errorCode.RIM-PFI-TOTAL-RES-FIN-COSTS.0">8462</sch:diagnostic>
    <sch:diagnostic id="transactional.RIM-PFI-TOTAL-RES-FIN-COSTS.0">The entry in [2.33A] must be equal to the total of all occurrences of [2.4.5]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.RIM-PFI-TOTAL-RES-FIN-COSTS.0">The entry in [2.33A] must be equal to the total of all occurrences of [2.4.5]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PDA-TOT-DISPOSAL-CHRGBLE-ASSET.global.29">6996</sch:diagnostic>
    <sch:diagnostic id="transactional.PDA-TOT-DISPOSAL-CHRGBLE-ASSET.global.29">There is an entry in [4.1.3]. Please complete box [4.1].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PDA-TOT-DISPOSAL-CHRGBLE-ASSET.global.29">There is an entry in [4.1.3]. Please complete box [4.1].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PDA-TOT-DISPOSAL-CHRGBLE-ASSET.0">6628</sch:diagnostic>
    <sch:diagnostic id="transactional.PDA-TOT-DISPOSAL-CHRGBLE-ASSET.0">The amount in box [4.1] must equal the total of [4.1.3]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PDA-TOT-DISPOSAL-CHRGBLE-ASSET.0">The amount in box [4.1] must equal the total of [4.1.3]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSI-TOTAL-UNTAXED-INTEREST.global.30">6997</sch:diagnostic>
    <sch:diagnostic id="transactional.PSI-TOTAL-UNTAXED-INTEREST.global.30">There is an entry in [7.3] or [7.4] or [7.5]. Please complete box [7.6].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSI-TOTAL-UNTAXED-INTEREST.global.30">There is an entry in [7.3] or [7.4] or [7.5]. Please complete box [7.6].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSI-TOTAL-INT-TAX-DEDUCTED.global.31">6998</sch:diagnostic>
    <sch:diagnostic id="transactional.PSI-TOTAL-INT-TAX-DEDUCTED.global.31">There is an entry in [7.8] or [7.15]. Please complete box [7.17].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSI-TOTAL-INT-TAX-DEDUCTED.global.31">There is an entry in [7.8] or [7.15]. Please complete box [7.17].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSI-TOTAL-INT-BEFORE-TAX-DED.global.32">6999</sch:diagnostic>
    <sch:diagnostic id="transactional.PSI-TOTAL-INT-BEFORE-TAX-DED.global.32">There is an entry in [7.9] or [7.16]. Please complete box [7.18].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSI-TOTAL-INT-BEFORE-TAX-DED.global.32">There is an entry in [7.9] or [7.16]. Please complete box [7.18].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSI3-TOTAL-TAXED-SAVINGS.global.35">6882</sch:diagnostic>
    <sch:diagnostic id="transactional.PSI3-TOTAL-TAXED-SAVINGS.global.35">There is an entry in [7.19] or [7.20] or [7.21] or [7.22]. Please complete box [7.23].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSI3-TOTAL-TAXED-SAVINGS.global.35">There is an entry in [7.19] or [7.20] or [7.21] or [7.22]. Please complete box [7.23].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSI-INTEREST-PERIOD-END-DATE.0">6643</sch:diagnostic>
    <sch:diagnostic id="transactional.PSI-INTEREST-PERIOD-END-DATE.0">The date in box [7.2] cannot be earlier than the date in box [7.1]. Please amend the incorrect entry.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSI-INTEREST-PERIOD-END-DATE.0">The date in box [7.2] cannot be earlier than the date in box [7.1]. Please amend the incorrect entry.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSI-TOTAL-UNTAXED-INTEREST.0">8463</sch:diagnostic>
    <sch:diagnostic id="transactional.PSI-TOTAL-UNTAXED-INTEREST.0">There is an entry in box [7.6] please complete [7.1] </sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSI-TOTAL-UNTAXED-INTEREST.0">There is an entry in box [7.6] please complete [7.1] </sch:diagnostic>
    <sch:diagnostic id="errorCode.PSI-TOTAL-UNTAXED-INTEREST.1">8464</sch:diagnostic>
    <sch:diagnostic id="transactional.PSI-TOTAL-UNTAXED-INTEREST.1">The amount in box [7.6] must equal ( the sum of [7.3], [7.4], and [7.5] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSI-TOTAL-UNTAXED-INTEREST.1">The amount in box [7.6] must equal ( the sum of [7.3], [7.4], and [7.5] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.SavingsBasicRateTax.0">6651</sch:diagnostic>
    <sch:diagnostic id="transactional.SavingsBasicRateTax.0">Tax must equal Gross Value * Lower savings rate (20%)</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SavingsBasicRateTax.0">Tax must equal Gross Value * Lower savings rate (20%)</sch:diagnostic>
    <sch:diagnostic id="errorCode.SavingsBasicRateGross.0">6652</sch:diagnostic>
    <sch:diagnostic id="transactional.SavingsBasicRateGross.0">Gross must equal Net plus Tax</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SavingsBasicRateGross.0">Gross must equal Net plus Tax</sch:diagnostic>
    <sch:diagnostic id="errorCode.SavingsBasicRateTax.0.0">6651</sch:diagnostic>
    <sch:diagnostic id="transactional.SavingsBasicRateTax.0.0">Tax must equal Gross Value * Lower savings rate (20%)</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SavingsBasicRateTax.0.0">Tax must equal Gross Value * Lower savings rate (20%)</sch:diagnostic>
    <sch:diagnostic id="errorCode.SavingsBasicRateGross.0.0">6652</sch:diagnostic>
    <sch:diagnostic id="transactional.SavingsBasicRateGross.0.0">Gross must equal Net plus Tax</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SavingsBasicRateGross.0.0">Gross must equal Net plus Tax</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSI-TOTAL-INT-TAX-DEDUCTED.0">6653</sch:diagnostic>
    <sch:diagnostic id="transactional.PSI-TOTAL-INT-TAX-DEDUCTED.0">The amount in box [7.17] must equal [7.8] + [7.15]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSI-TOTAL-INT-TAX-DEDUCTED.0">The amount in box [7.17] must equal [7.8] + [7.15]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSI-TOTAL-INT-BEFORE-TAX-DED.0">6654</sch:diagnostic>
    <sch:diagnostic id="transactional.PSI-TOTAL-INT-BEFORE-TAX-DED.0">The amount in box [7.18] must equal [7.9] + [7.16]. Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSI-TOTAL-INT-BEFORE-TAX-DED.0">The amount in box [7.18] must equal [7.9] + [7.16]. Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSI3-TOTAL-TAXED-SAVINGS.0">6665</sch:diagnostic>
    <sch:diagnostic id="transactional.PSI3-TOTAL-TAXED-SAVINGS.0">The amount in box [7.23] must equal ( the sum of [7.19], [7.20], [7.21], and [7.22] ). Please check.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSI3-TOTAL-TAXED-SAVINGS.0">The amount in box [7.23] must equal ( the sum of [7.19], [7.20], [7.21], and [7.22] ). Please check.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSI-OTHER-PERIOD-END-DATE.0">6666</sch:diagnostic>
    <sch:diagnostic id="transactional.PSI-OTHER-PERIOD-END-DATE.0">The date in box [7.25] cannot be earlier than the date in box [7.24]. Please amend the incorrect entry.</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSI-OTHER-PERIOD-END-DATE.0">The date in box [7.25] cannot be earlier than the date in box [7.24]. Please amend the incorrect entry.</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSI-OTHER-UNTAXED-UK-INCOME.0">6667</sch:diagnostic>
    <sch:diagnostic id="transactional.PSI-OTHER-UNTAXED-UK-INCOME.0">There is an amount in box [7.26]. Please complete box [7.24].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSI-OTHER-UNTAXED-UK-INCOME.0">There is an amount in box [7.26]. Please complete box [7.24].</sch:diagnostic>
    <sch:diagnostic id="errorCode.PSI-OTHER-UNTAXED-UK-INC-LOSS.0">6668</sch:diagnostic>
    <sch:diagnostic id="transactional.PSI-OTHER-UNTAXED-UK-INC-LOSS.0">There is an amount in box [7.27]. Please complete box [7.24].</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PSI-OTHER-UNTAXED-UK-INC-LOSS.0">There is an amount in box [7.27]. Please complete box [7.24].</sch:diagnostic>
    <sch:diagnostic id="errorCode.SavingsBasicRateTax.0.1">6651</sch:diagnostic>
    <sch:diagnostic id="transactional.SavingsBasicRateTax.0.1">Tax must equal Gross Value * Lower savings rate (20%)</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SavingsBasicRateTax.0.1">Tax must equal Gross Value * Lower savings rate (20%)</sch:diagnostic>
    <sch:diagnostic id="errorCode.SavingsBasicRateGross.0.1">6652</sch:diagnostic>
    <sch:diagnostic id="transactional.SavingsBasicRateGross.0.1">Gross must equal Net plus Tax</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.SavingsBasicRateGross.0.1">Gross must equal Net plus Tax</sch:diagnostic>
    <sch:diagnostic id="errorCode.PTR-ATTACHMENT.1">6790</sch:diagnostic>
    <sch:diagnostic id="transactional.PTR-ATTACHMENT.1">The attachment content must be a PDF file</sch:diagnostic>
    <sch:diagnostic xml:lang="en" id="transactional.en.PTR-ATTACHMENT.1">The attachment content must be a PDF file</sch:diagnostic>
  </sch:diagnostics>
</sch:schema>
